/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.beta.generator;

import java.util.Objects;

public interface RelationshipPropertyProducer {
    public static RelationshipPropertyProducer fixed(String propertyName, double value) {
        return new Fixed(propertyName, value);
    }

    public static RelationshipPropertyProducer random(String propertyName, double min, double max) {
        return new Random(propertyName, min, max);
    }

    public String getPropertyName();

    public double getPropertyValue(long var1, long var3, java.util.Random var5);

    public static class Random
    implements RelationshipPropertyProducer {
        private final String propertyName;
        private final double min;
        private final double max;

        public Random(String propertyName, double min, double max) {
            this.propertyName = propertyName;
            this.min = min;
            this.max = max;
            if (max <= min) {
                throw new IllegalArgumentException("Max value must be greater than min value");
            }
        }

        @Override
        public String getPropertyName() {
            return this.propertyName;
        }

        @Override
        public double getPropertyValue(long source, long target, java.util.Random random) {
            return this.min + random.nextDouble() * (this.max - this.min);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Random random = (Random)o;
            return Double.compare(random.min, this.min) == 0 && Double.compare(random.max, this.max) == 0 && Objects.equals(this.propertyName, random.propertyName);
        }

        public int hashCode() {
            return Objects.hash(this.propertyName, this.min, this.max);
        }

        public String toString() {
            return "Random{propertyName='" + this.propertyName + '\'' + ", min=" + this.min + ", max=" + this.max + '}';
        }
    }

    public static class Fixed
    implements RelationshipPropertyProducer {
        private final String propertyName;
        private final double value;

        public Fixed(String propertyName, double value) {
            this.propertyName = propertyName;
            this.value = value;
        }

        @Override
        public String getPropertyName() {
            return this.propertyName;
        }

        @Override
        public double getPropertyValue(long source, long target, java.util.Random random) {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Fixed fixed = (Fixed)o;
            return Double.compare(fixed.value, this.value) == 0 && Objects.equals(this.propertyName, fixed.propertyName);
        }

        public int hashCode() {
            return Objects.hash(this.propertyName, this.value);
        }

        public String toString() {
            return "Fixed{propertyName='" + this.propertyName + '\'' + ", value=" + this.value + '}';
        }
    }
}

