/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.beta.generator;

import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.function.LongUnaryOperator;
import org.jetbrains.annotations.Nullable;
import org.neo4j.graphalgo.Orientation;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.beta.generator.RelationshipDistribution;
import org.neo4j.graphalgo.beta.generator.RelationshipPropertyProducer;
import org.neo4j.graphalgo.config.RandomGraphGeneratorConfig;
import org.neo4j.graphalgo.core.Aggregation;
import org.neo4j.graphalgo.core.concurrency.Pools;
import org.neo4j.graphalgo.core.huge.HugeGraph;
import org.neo4j.graphalgo.core.loading.HugeGraphUtil;
import org.neo4j.graphalgo.core.loading.IdMap;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;

public final class RandomGraphGenerator {
    private final AllocationTracker allocationTracker;
    private final long nodeCount;
    private final long averageDegree;
    private final Random random;
    private final RelationshipDistribution relationshipDistribution;
    private final Aggregation aggregation;
    private final Orientation orientation;
    private final RandomGraphGeneratorConfig.AllowSelfLoops allowSelfLoops;
    private final Optional<RelationshipPropertyProducer> maybePropertyProducer;

    public static Graph generate(int nodeCount, int averageDegree) {
        return RandomGraphGenerator.generate(nodeCount, averageDegree, RelationshipDistribution.POWER_LAW);
    }

    public static Graph generate(int nodeCount, int averageDegree, RelationshipDistribution distribution) {
        return RandomGraphGenerator.generate(nodeCount, averageDegree, distribution, null);
    }

    public static Graph generate(int nodeCount, int averageDegree, RelationshipDistribution distribution, @Nullable Long seed) {
        return new RandomGraphGenerator(nodeCount, averageDegree, distribution, seed, Optional.empty(), Aggregation.NONE, Orientation.NATURAL, RandomGraphGeneratorConfig.AllowSelfLoops.NO, AllocationTracker.EMPTY).generate();
    }

    public RandomGraphGenerator(long nodeCount, long averageDegree, RelationshipDistribution relationshipDistribution, @Nullable Long seed, Optional<RelationshipPropertyProducer> maybePropertyProducer, Aggregation aggregation, Orientation orientation, RandomGraphGeneratorConfig.AllowSelfLoops allowSelfLoops, AllocationTracker allocationTracker) {
        this.relationshipDistribution = relationshipDistribution;
        this.maybePropertyProducer = maybePropertyProducer;
        this.allocationTracker = allocationTracker;
        this.nodeCount = nodeCount;
        this.averageDegree = averageDegree;
        this.aggregation = aggregation;
        this.orientation = orientation;
        this.allowSelfLoops = allowSelfLoops;
        this.random = new Random();
        if (seed != null) {
            this.random.setSeed(seed);
        }
    }

    public RandomGraphGenerator(long nodeCount, long averageDegree, RelationshipDistribution relationshipDistribution, Long seed, Optional<RelationshipPropertyProducer> maybePropertyProducer, AllocationTracker allocationTracker) {
        this(nodeCount, averageDegree, relationshipDistribution, seed, maybePropertyProducer, Aggregation.NONE, Orientation.NATURAL, RandomGraphGeneratorConfig.AllowSelfLoops.NO, allocationTracker);
    }

    public RandomGraphGenerator(long nodeCount, long averageDegree, RelationshipDistribution relationshipDistribution, Optional<RelationshipPropertyProducer> maybePropertyProducer, AllocationTracker allocationTracker) {
        this(nodeCount, averageDegree, relationshipDistribution, null, maybePropertyProducer, allocationTracker);
    }

    public HugeGraph generate() {
        HugeGraphUtil.IdMapBuilder idMapBuilder = HugeGraphUtil.idMapBuilder((long)this.nodeCount, (ExecutorService)Pools.DEFAULT, (AllocationTracker)this.allocationTracker);
        this.generateNodes(idMapBuilder);
        IdMap idMap = idMapBuilder.build();
        HugeGraphUtil.RelationshipsBuilder relationshipsBuilder = HugeGraphUtil.createRelImporter((IdMap)idMap, (Orientation)this.orientation, (boolean)this.maybePropertyProducer.isPresent(), (Aggregation)this.aggregation, (ExecutorService)Pools.DEFAULT, (AllocationTracker)this.allocationTracker);
        this.generateRelationships(relationshipsBuilder);
        return HugeGraphUtil.create((IdMap)idMap, (HugeGraph.Relationships)relationshipsBuilder.build(), (AllocationTracker)this.allocationTracker);
    }

    public RelationshipDistribution getRelationshipDistribution() {
        return this.relationshipDistribution;
    }

    public Optional<RelationshipPropertyProducer> getMaybePropertyProducer() {
        return this.maybePropertyProducer;
    }

    private void generateNodes(HugeGraphUtil.IdMapBuilder idMapBuilder) {
        for (long i = 0L; i < this.nodeCount; ++i) {
            idMapBuilder.addNode(i);
        }
    }

    private void generateRelationships(HugeGraphUtil.RelationshipsBuilder relationshipsImporter) {
        LongUnaryOperator degreeProducer = this.relationshipDistribution.degreeProducer(this.nodeCount, this.averageDegree, this.random);
        LongUnaryOperator relationshipProducer = this.relationshipDistribution.relationshipProducer(this.nodeCount, this.averageDegree, this.random);
        RelationshipPropertyProducer relationshipPropertyProducer = this.maybePropertyProducer.orElse(new EmptyRelationshipPropertyProducer());
        for (long nodeId = 0L; nodeId < this.nodeCount; ++nodeId) {
            long degree = degreeProducer.applyAsLong(nodeId);
            int j = 0;
            while ((long)j < degree) {
                long targetId;
                if (this.allowSelfLoops.value()) {
                    targetId = relationshipProducer.applyAsLong(nodeId);
                } else {
                    while ((targetId = relationshipProducer.applyAsLong(nodeId)) == nodeId) {
                    }
                }
                assert (targetId < this.nodeCount);
                double property = relationshipPropertyProducer.getPropertyValue(nodeId, targetId, this.random);
                relationshipsImporter.addFromInternal(nodeId, targetId, property);
                ++j;
            }
        }
    }

    static class EmptyRelationshipPropertyProducer
    implements RelationshipPropertyProducer {
        EmptyRelationshipPropertyProducer() {
        }

        @Override
        public String getPropertyName() {
            return null;
        }

        @Override
        public double getPropertyValue(long source, long target, Random random) {
            return 0.0;
        }
    }
}

