/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.connection.netty.impl.async.connection;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOption;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;

final class SslHandshakeDurationHandler
extends ChannelInboundHandlerAdapter {
    private final CompletableFuture<Duration> sslHandshakeFuture;
    private Instant startInstant;

    SslHandshakeDurationHandler(Channel channel, CompletableFuture<Duration> sslHandshakeFuture) {
        this.sslHandshakeFuture = sslHandshakeFuture;
        boolean fastOpen = Boolean.TRUE.equals(channel.config().getOption(ChannelOption.TCP_FASTOPEN_CONNECT));
        if (fastOpen) {
            this.startInstant = Instant.now();
        }
    }

    public void channelActive(ChannelHandlerContext ctx) {
        if (this.startInstant == null) {
            this.startInstant = Instant.now();
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof SslHandshakeCompletionEvent) {
            SslHandshakeCompletionEvent event = (SslHandshakeCompletionEvent)evt;
            if (event.isSuccess()) {
                Duration duration = Duration.between(this.startInstant, Instant.now());
                this.sslHandshakeFuture.complete(duration);
            } else {
                this.sslHandshakeFuture.completeExceptionally(event.cause());
            }
            ctx.pipeline().remove((ChannelHandler)this);
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (!this.sslHandshakeFuture.isDone()) {
            this.sslHandshakeFuture.completeExceptionally(new IOException("Inactive channel before SSL handshake is finished"));
        }
        super.channelInactive(ctx);
    }
}

