/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.indexaccum;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseIndexAccumulation;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.factory.Nd4j;

public class IAMax
extends BaseIndexAccumulation {
    public IAMax() {
    }

    public IAMax(INDArray x, INDArray y, long n) {
        super(x, y, n);
    }

    public IAMax(INDArray x) {
        super(x);
    }

    public IAMax(INDArray x, INDArray y) {
        super(x, y);
    }

    @Override
    public int update(double accum, int accumIdx, double x, int xIdx) {
        return FastMath.abs((double)accum) >= FastMath.abs((double)x) ? accumIdx : xIdx;
    }

    @Override
    public int update(float accum, int accumIdx, float x, int xIdx) {
        return FastMath.abs((float)accum) >= FastMath.abs((float)x) ? accumIdx : xIdx;
    }

    @Override
    public int update(double accum, int accumIdx, double x, double y, int idx) {
        return FastMath.abs((double)accum) >= FastMath.abs((double)x) ? accumIdx : idx;
    }

    @Override
    public int update(float accum, int accumIdx, float x, float y, int idx) {
        return FastMath.abs((float)accum) >= FastMath.abs((float)x) ? accumIdx : idx;
    }

    @Override
    public int update(IComplexNumber accum, int accumIdx, IComplexNumber x, int xIdx) {
        return accum.absoluteValue().doubleValue() >= x.absoluteValue().doubleValue() ? accumIdx : xIdx;
    }

    @Override
    public int update(IComplexNumber accum, int accumIdx, double x, int idx) {
        return accum.absoluteValue().doubleValue() >= FastMath.abs((double)x) ? accumIdx : idx;
    }

    @Override
    public int update(IComplexNumber accum, int accumIdx, double x, double y, int idx) {
        return accum.absoluteValue().doubleValue() >= FastMath.abs((double)x) ? accumIdx : idx;
    }

    @Override
    public int update(IComplexNumber accum, int accumIdx, IComplexNumber x, IComplexNumber y, int idx) {
        return accum.absoluteValue().doubleValue() >= x.absoluteValue().doubleValue() ? accumIdx : idx;
    }

    @Override
    public int opNum() {
        return 0;
    }

    @Override
    public String name() {
        return "iamax";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        return Nd4j.createComplexNumber(origin.absoluteValue(), 0);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        return Nd4j.createComplexNumber(origin.absoluteValue(), 0);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        return Nd4j.createComplexNumber(origin.absoluteValue(), 0);
    }

    @Override
    public float op(float origin, float other) {
        return FastMath.abs((float)origin);
    }

    @Override
    public double op(double origin, double other) {
        return FastMath.abs((double)origin);
    }

    @Override
    public double op(double origin) {
        return origin;
    }

    @Override
    public float op(float origin) {
        return FastMath.abs((float)origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        return Nd4j.createComplexNumber(origin.absoluteValue(), 0);
    }

    @Override
    public double zeroDouble() {
        return 0.0;
    }

    @Override
    public float zeroFloat() {
        return 0.0f;
    }

    @Override
    public IComplexNumber zeroComplex() {
        return Nd4j.createComplexNumber(0, 0);
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new IAMax(xAlongDimension, this.y.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new IAMax(this.x.vectorAlongDimension(index, dimension));
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new IAMax(xAlongDimension, this.y.tensorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new IAMax(this.x.tensorAlongDimension(index, dimension));
    }
}

