/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops;

import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseOp;
import org.nd4j.linalg.api.ops.BroadcastOp;
import org.nd4j.linalg.api.ops.Op;

public abstract class BaseBroadcastOp
extends BaseOp
implements BroadcastOp {
    protected int[] dimension;

    public BaseBroadcastOp(INDArray x, INDArray y, INDArray z, int ... dimension) {
        super(x, y, z, x.lengthLong());
        this.dimension = dimension;
        for (int i = 0; i < dimension.length; ++i) {
            if (dimension[i] >= 0) continue;
            int n = i;
            dimension[n] = dimension[n] + x.rank();
        }
        if (dimension.length == 1 && y.length() != x.size(dimension[0])) {
            throw new IllegalArgumentException("Unable to broadcast y along dimension " + dimension[0] + " dimension must be same length");
        }
    }

    @Override
    public int broadcastLength() {
        if (this.y == null) {
            throw new IllegalStateException("Unable to get broad cast length for y, no y specified");
        }
        return this.y.length();
    }

    @Override
    public int[] broadcastShape() {
        if (this.y == null) {
            throw new IllegalStateException("Unable to get broad cast shape for y, no y specified");
        }
        return this.y.shape();
    }

    @Override
    public int[] getDimension() {
        return this.dimension;
    }

    @Override
    public void setDimension(int ... dimension) {
        this.dimension = dimension;
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        throw new UnsupportedOperationException("opForDimension not supported for BroadcastOps");
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        throw new UnsupportedOperationException("opForDimension not supported for BroadcastOps");
    }

    public BaseBroadcastOp() {
    }
}

