/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.shade.guava.io;

import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.nd4j.shade.guava.annotations.Beta;
import org.nd4j.shade.guava.annotations.GwtIncompatible;
import org.nd4j.shade.guava.base.Preconditions;

@Beta
@GwtIncompatible
public final class PatternFilenameFilter
implements FilenameFilter {
    private final Pattern pattern;

    public PatternFilenameFilter(String patternStr) {
        this(Pattern.compile(patternStr));
    }

    public PatternFilenameFilter(Pattern pattern) {
        this.pattern = Preconditions.checkNotNull(pattern);
    }

    @Override
    public boolean accept(@Nullable File dir, String fileName) {
        return this.pattern.matcher(fileName).matches();
    }
}

