/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.spring.batch;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.ibatis.cursor.Cursor;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.batch.infrastructure.item.support.AbstractItemCountingItemStreamItemReader;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class MyBatisCursorItemReader<T>
extends AbstractItemCountingItemStreamItemReader<T>
implements InitializingBean {
    private String queryId;
    private SqlSessionFactory sqlSessionFactory;
    private SqlSession sqlSession;
    private Map<String, Object> parameterValues;
    private Supplier<Map<String, Object>> parameterValuesSupplier;
    private Cursor<T> cursor;
    private Iterator<T> cursorIterator;

    public MyBatisCursorItemReader() {
        this.setName(ClassUtils.getShortName(MyBatisCursorItemReader.class));
    }

    protected T doRead() throws Exception {
        T next = null;
        if (this.cursorIterator.hasNext()) {
            next = this.cursorIterator.next();
        }
        return next;
    }

    protected void doOpen() throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (this.parameterValues != null) {
            parameters.putAll(this.parameterValues);
        }
        Optional.ofNullable(this.parameterValuesSupplier).map(Supplier::get).ifPresent(parameters::putAll);
        this.sqlSession = this.sqlSessionFactory.openSession(ExecutorType.SIMPLE);
        this.cursor = this.sqlSession.selectCursor(this.queryId, parameters);
        this.cursorIterator = this.cursor.iterator();
    }

    protected void doClose() throws Exception {
        if (this.cursor != null) {
            this.cursor.close();
        }
        if (this.sqlSession != null) {
            this.sqlSession.close();
        }
        this.cursorIterator = null;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.sqlSessionFactory, (String)"A SqlSessionFactory is required.");
        Assert.notNull((Object)this.queryId, (String)"A queryId is required.");
    }

    public void setSqlSessionFactory(SqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
    }

    public void setQueryId(String queryId) {
        this.queryId = queryId;
    }

    public void setParameterValues(Map<String, Object> parameterValues) {
        this.parameterValues = parameterValues;
    }

    public void setParameterValuesSupplier(Supplier<Map<String, Object>> parameterValuesSupplier) {
        this.parameterValuesSupplier = parameterValuesSupplier;
    }
}

