/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.spring;

import java.sql.SQLException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.apache.ibatis.exceptions.PersistenceException;
import org.mybatis.spring.MyBatisSystemException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.jdbc.UncategorizedSQLException;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.transaction.TransactionException;

public class MyBatisExceptionTranslator
implements PersistenceExceptionTranslator {
    private final Supplier<SQLExceptionTranslator> exceptionTranslatorSupplier;
    private SQLExceptionTranslator exceptionTranslator;
    private ReentrantLock lock = new ReentrantLock();

    public MyBatisExceptionTranslator(DataSource dataSource, boolean exceptionTranslatorLazyInit) {
        this(() -> new SQLErrorCodeSQLExceptionTranslator(dataSource), exceptionTranslatorLazyInit);
    }

    public MyBatisExceptionTranslator(Supplier<SQLExceptionTranslator> exceptionTranslatorSupplier, boolean exceptionTranslatorLazyInit) {
        this.exceptionTranslatorSupplier = exceptionTranslatorSupplier;
        if (!exceptionTranslatorLazyInit) {
            this.initExceptionTranslator();
        }
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException e) {
        if (e instanceof PersistenceException) {
            String msg = e.getMessage();
            if (e.getCause() instanceof PersistenceException) {
                e = (PersistenceException)e.getCause();
                if (msg == null) {
                    msg = e.getMessage();
                }
            }
            if (e.getCause() instanceof SQLException) {
                this.initExceptionTranslator();
                String task = e.getMessage() + "\n";
                SQLException se = (SQLException)e.getCause();
                DataAccessException dae = this.exceptionTranslator.translate(task, null, se);
                return dae != null ? dae : new UncategorizedSQLException(task, null, se);
            }
            if (e.getCause() instanceof TransactionException) {
                throw (TransactionException)e.getCause();
            }
            return new MyBatisSystemException(msg, e);
        }
        return null;
    }

    private void initExceptionTranslator() {
        this.lock.lock();
        try {
            if (this.exceptionTranslator == null) {
                this.exceptionTranslator = this.exceptionTranslatorSupplier.get();
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

