/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.insert.render;

import java.util.Objects;
import org.mybatis.dynamic.sql.insert.MultiRowInsertModel;
import org.mybatis.dynamic.sql.insert.render.DefaultMultiRowInsertStatementProvider;
import org.mybatis.dynamic.sql.insert.render.FieldAndValueCollector;
import org.mybatis.dynamic.sql.insert.render.MultiRowInsertStatementProvider;
import org.mybatis.dynamic.sql.insert.render.MultiRowRenderingUtilities;
import org.mybatis.dynamic.sql.insert.render.MultiRowValuePhraseVisitor;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.util.StringUtilities;

public class MultiRowInsertRenderer<T> {
    private MultiRowInsertModel<T> model;
    private RenderingStrategy renderingStrategy;

    private MultiRowInsertRenderer(Builder<T> builder) {
        this.model = Objects.requireNonNull(((Builder)builder).model);
        this.renderingStrategy = Objects.requireNonNull(((Builder)builder).renderingStrategy);
    }

    public MultiRowInsertStatementProvider<T> render() {
        MultiRowValuePhraseVisitor visitor = new MultiRowValuePhraseVisitor(this.renderingStrategy);
        FieldAndValueCollector collector = this.model.mapColumnMappings(MultiRowRenderingUtilities.toFieldAndValue(visitor)).collect(FieldAndValueCollector.collect());
        return new DefaultMultiRowInsertStatementProvider.Builder().withRecords(this.model.records()).withInsertStatement(this.calculateInsertStatement(collector)).build();
    }

    private String calculateInsertStatement(FieldAndValueCollector collector) {
        return "insert into" + StringUtilities.spaceBefore(this.model.table().tableNameAtRuntime()) + StringUtilities.spaceBefore(collector.columnsPhrase()) + StringUtilities.spaceBefore(collector.multiRowInsertValuesPhrase(this.model.recordCount()));
    }

    public static <T> Builder<T> withMultiRowInsertModel(MultiRowInsertModel<T> model) {
        return new Builder<T>().withMultiRowInsertModel(model);
    }

    public static class Builder<T> {
        private MultiRowInsertModel<T> model;
        private RenderingStrategy renderingStrategy;

        public Builder<T> withMultiRowInsertModel(MultiRowInsertModel<T> model) {
            this.model = model;
            return this;
        }

        public Builder<T> withRenderingStrategy(RenderingStrategy renderingStrategy) {
            this.renderingStrategy = renderingStrategy;
            return this;
        }

        public MultiRowInsertRenderer<T> build() {
            return new MultiRowInsertRenderer(this);
        }
    }
}

