/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.insert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.mybatis.dynamic.sql.SqlTable;
import org.mybatis.dynamic.sql.util.InsertMapping;

public abstract class AbstractMultiRowInsertModel<T> {
    private SqlTable table;
    private List<T> records;
    private List<InsertMapping> columnMappings;

    protected AbstractMultiRowInsertModel(AbstractBuilder<T, ?> builder) {
        this.table = Objects.requireNonNull(((AbstractBuilder)builder).table);
        this.records = Collections.unmodifiableList(Objects.requireNonNull(((AbstractBuilder)builder).records));
        this.columnMappings = Objects.requireNonNull(((AbstractBuilder)builder).columnMappings);
    }

    public <R> Stream<R> mapColumnMappings(Function<InsertMapping, R> mapper) {
        return this.columnMappings.stream().map(mapper);
    }

    public List<T> records() {
        return this.records;
    }

    public SqlTable table() {
        return this.table;
    }

    public int recordCount() {
        return this.records.size();
    }

    public static abstract class AbstractBuilder<T, S extends AbstractBuilder<T, S>> {
        private SqlTable table;
        private List<T> records = new ArrayList<T>();
        private List<InsertMapping> columnMappings = new ArrayList<InsertMapping>();

        public S withTable(SqlTable table) {
            this.table = table;
            return this.getThis();
        }

        public S withRecords(Collection<T> records) {
            this.records.addAll(records);
            return this.getThis();
        }

        public S withColumnMappings(List<InsertMapping> columnMappings) {
            this.columnMappings.addAll(columnMappings);
            return this.getThis();
        }

        protected abstract S getThis();
    }
}

