/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.boxes.iso14496.part12;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.mp4parser.BoxParser;
import org.mp4parser.ParsableBox;
import org.mp4parser.support.DoNotParseDetail;

public final class MediaDataBox
implements ParsableBox,
Closeable {
    public static final String TYPE = "mdat";
    ByteBuffer header;
    File dataFile;

    @Override
    public String getType() {
        return TYPE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void getBox(WritableByteChannel writableByteChannel) throws IOException {
        writableByteChannel.write((ByteBuffer)((Buffer)this.header).rewind());
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            FileInputStream fis = new FileInputStream(this.dataFile);
            try {
                try (FileChannel fc = fis.getChannel();){
                    fc.transferTo(0L, this.dataFile.lastModified(), writableByteChannel);
                }
                if (fis == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (fis == null) throw throwable;
                fis.close();
                throw throwable;
            }
            fis.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    @Override
    public long getSize() {
        return (long)this.header.limit() + this.dataFile.length();
    }

    @Override
    @DoNotParseDetail
    public void parse(ReadableByteChannel dataSource, ByteBuffer header, long contentSize, BoxParser boxParser) throws IOException {
        this.dataFile = File.createTempFile("MediaDataBox", super.toString());
        this.dataFile.deleteOnExit();
        this.header = ByteBuffer.allocate(header.limit());
        this.header.put(header);
        Throwable throwable = null;
        Object var7_7 = null;
        try (RandomAccessFile raf = new RandomAccessFile(this.dataFile, "rw");){
            raf.getChannel().transferFrom(dataSource, 0L, contentSize);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.dataFile != null) {
            this.dataFile.delete();
        }
    }
}

