/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.uma.model;

import java.util.Collection;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.mitre.uma.model.Claim;

@Entity
@Table(name="policy")
public class Policy {
    private Long id;
    private String name;
    private Collection<Claim> claimsRequired;
    private Set<String> scopes;

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Basic
    @Column(name="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinTable(name="claim_to_policy", joinColumns={@JoinColumn(name="policy_id")}, inverseJoinColumns={@JoinColumn(name="claim_id")})
    public Collection<Claim> getClaimsRequired() {
        return this.claimsRequired;
    }

    public void setClaimsRequired(Collection<Claim> claimsRequired) {
        this.claimsRequired = claimsRequired;
    }

    @ElementCollection(fetch=FetchType.EAGER)
    @Column(name="scope")
    @CollectionTable(name="policy_scope", joinColumns={@JoinColumn(name="owner_id")})
    public Set<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(Set<String> scopes) {
        this.scopes = scopes;
    }

    public String toString() {
        return "Policy [id=" + this.id + ", name=" + this.name + ", claimsRequired=" + this.claimsRequired + ", scopes=" + this.scopes + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.claimsRequired == null ? 0 : this.claimsRequired.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.scopes == null ? 0 : this.scopes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Policy other = (Policy)obj;
        if (this.claimsRequired == null ? other.claimsRequired != null : !this.claimsRequired.equals(other.claimsRequired)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.scopes == null ? other.scopes != null : !this.scopes.equals(other.scopes));
    }
}

