/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.model;

import com.nimbusds.jwt.JWT;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.mitre.oauth2.model.AuthenticationHolderEntity;
import org.mitre.oauth2.model.ClientDetailsEntity;
import org.mitre.oauth2.model.convert.JWTStringConverter;
import org.springframework.security.oauth2.common.OAuth2RefreshToken;

@Entity
@Table(name="refresh_token")
@NamedQueries(value={@NamedQuery(name="OAuth2RefreshTokenEntity.getAll", query="select r from OAuth2RefreshTokenEntity r"), @NamedQuery(name="OAuth2RefreshTokenEntity.getAllExpiredByDate", query="select r from OAuth2RefreshTokenEntity r where r.expiration <= :date"), @NamedQuery(name="OAuth2RefreshTokenEntity.getByClient", query="select r from OAuth2RefreshTokenEntity r where r.client = :client"), @NamedQuery(name="OAuth2RefreshTokenEntity.getByTokenValue", query="select r from OAuth2RefreshTokenEntity r where r.jwt = :tokenValue"), @NamedQuery(name="OAuth2RefreshTokenEntity.getByName", query="select r from OAuth2RefreshTokenEntity r where r.authenticationHolder.userAuth.name = :name")})
public class OAuth2RefreshTokenEntity
implements OAuth2RefreshToken {
    public static final String QUERY_BY_TOKEN_VALUE = "OAuth2RefreshTokenEntity.getByTokenValue";
    public static final String QUERY_BY_CLIENT = "OAuth2RefreshTokenEntity.getByClient";
    public static final String QUERY_EXPIRED_BY_DATE = "OAuth2RefreshTokenEntity.getAllExpiredByDate";
    public static final String QUERY_ALL = "OAuth2RefreshTokenEntity.getAll";
    public static final String QUERY_BY_NAME = "OAuth2RefreshTokenEntity.getByName";
    public static final String PARAM_TOKEN_VALUE = "tokenValue";
    public static final String PARAM_CLIENT = "client";
    public static final String PARAM_DATE = "date";
    public static final String PARAM_NAME = "name";
    private Long id;
    private AuthenticationHolderEntity authenticationHolder;
    private ClientDetailsEntity client;
    private JWT jwt;
    private Date expiration;

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @ManyToOne
    @JoinColumn(name="auth_holder_id")
    public AuthenticationHolderEntity getAuthenticationHolder() {
        return this.authenticationHolder;
    }

    public void setAuthenticationHolder(AuthenticationHolderEntity authenticationHolder) {
        this.authenticationHolder = authenticationHolder;
    }

    @Transient
    public String getValue() {
        return this.jwt.serialize();
    }

    @Basic
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="expiration")
    public Date getExpiration() {
        return this.expiration;
    }

    public void setExpiration(Date expiration) {
        this.expiration = expiration;
    }

    @Transient
    public boolean isExpired() {
        return this.getExpiration() == null ? false : System.currentTimeMillis() > this.getExpiration().getTime();
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="client_id")
    public ClientDetailsEntity getClient() {
        return this.client;
    }

    public void setClient(ClientDetailsEntity client) {
        this.client = client;
    }

    @Basic
    @Column(name="token_value")
    @Convert(converter=JWTStringConverter.class)
    public JWT getJwt() {
        return this.jwt;
    }

    public void setJwt(JWT jwt) {
        this.jwt = jwt;
    }
}

