/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.jwt.signer.service.impl;

import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.JWKSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.mitre.jose.keystore.JWKSetKeyStore;
import org.mitre.jwt.encryption.service.JWTEncryptionAndDecryptionService;
import org.mitre.jwt.encryption.service.impl.DefaultJWTEncryptionAndDecryptionService;
import org.mitre.jwt.signer.service.JWTSigningAndValidationService;
import org.mitre.jwt.signer.service.impl.DefaultJWTSigningAndValidationService;
import org.mitre.jwt.signer.service.impl.JWKSetCacheService;
import org.mitre.jwt.signer.service.impl.SymmetricKeyJWTValidatorCacheService;
import org.mitre.oauth2.model.ClientDetailsEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ClientKeyCacheService {
    private static Logger logger = LoggerFactory.getLogger(ClientKeyCacheService.class);
    @Autowired
    private JWKSetCacheService jwksUriCache = new JWKSetCacheService();
    @Autowired
    private SymmetricKeyJWTValidatorCacheService symmetricCache = new SymmetricKeyJWTValidatorCacheService();
    private LoadingCache<JWKSet, JWTSigningAndValidationService> jwksValidators = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).maximumSize(100L).build((CacheLoader)new JWKSetVerifierBuilder());
    private LoadingCache<JWKSet, JWTEncryptionAndDecryptionService> jwksEncrypters = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).maximumSize(100L).build((CacheLoader)new JWKSetEncryptorBuilder());

    public JWTSigningAndValidationService getValidator(ClientDetailsEntity client, JWSAlgorithm alg) {
        try {
            if (alg.equals((Object)JWSAlgorithm.RS256) || alg.equals((Object)JWSAlgorithm.RS384) || alg.equals((Object)JWSAlgorithm.RS512) || alg.equals((Object)JWSAlgorithm.ES256) || alg.equals((Object)JWSAlgorithm.ES384) || alg.equals((Object)JWSAlgorithm.ES512) || alg.equals((Object)JWSAlgorithm.PS256) || alg.equals((Object)JWSAlgorithm.PS384) || alg.equals((Object)JWSAlgorithm.PS512)) {
                if (client.getJwks() != null) {
                    return (JWTSigningAndValidationService)this.jwksValidators.get((Object)client.getJwks());
                }
                if (!Strings.isNullOrEmpty((String)client.getJwksUri())) {
                    return this.jwksUriCache.getValidator(client.getJwksUri());
                }
                return null;
            }
            if (alg.equals((Object)JWSAlgorithm.HS256) || alg.equals((Object)JWSAlgorithm.HS384) || alg.equals((Object)JWSAlgorithm.HS512)) {
                return this.symmetricCache.getSymmetricValidtor(client);
            }
            return null;
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            logger.error("Problem loading client validator", e);
            return null;
        }
    }

    public JWTEncryptionAndDecryptionService getEncrypter(ClientDetailsEntity client) {
        try {
            if (client.getJwks() != null) {
                return (JWTEncryptionAndDecryptionService)this.jwksEncrypters.get((Object)client.getJwks());
            }
            if (!Strings.isNullOrEmpty((String)client.getJwksUri())) {
                return this.jwksUriCache.getEncrypter(client.getJwksUri());
            }
            return null;
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            logger.error("Problem loading client encrypter", e);
            return null;
        }
    }

    private class JWKSetVerifierBuilder
    extends CacheLoader<JWKSet, JWTSigningAndValidationService> {
        private JWKSetVerifierBuilder() {
        }

        public JWTSigningAndValidationService load(JWKSet key) throws Exception {
            return new DefaultJWTSigningAndValidationService(new JWKSetKeyStore(key));
        }
    }

    private class JWKSetEncryptorBuilder
    extends CacheLoader<JWKSet, JWTEncryptionAndDecryptionService> {
        private JWKSetEncryptorBuilder() {
        }

        public JWTEncryptionAndDecryptionService load(JWKSet key) throws Exception {
            return new DefaultJWTEncryptionAndDecryptionService(new JWKSetKeyStore(key));
        }
    }
}

