/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.export;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import org.mariadb.jdbc.HostAddress;

public enum HaMode {
    REPLICATION("replication"){

        @Override
        public Optional<HostAddress> getAvailableHost(List<HostAddress> hostAddresses, ConcurrentMap<HostAddress, Long> denyList, boolean primary) {
            return HaMode.getAvailableHostInOrder(hostAddresses, denyList, primary);
        }
    }
    ,
    SEQUENTIAL("sequential"){

        @Override
        public Optional<HostAddress> getAvailableHost(List<HostAddress> hostAddresses, ConcurrentMap<HostAddress, Long> denyList, boolean primary) {
            return 2.getAvailableHostInOrder(hostAddresses, denyList, primary);
        }
    }
    ,
    LOADBALANCE("load-balance"){

        @Override
        public Optional<HostAddress> getAvailableHost(List<HostAddress> hostAddresses, ConcurrentMap<HostAddress, Long> denyList, boolean primary) {
            ArrayList<HostAddress> loopAddress = new ArrayList<HostAddress>(hostAddresses);
            denyList.entrySet().stream().filter(e -> (Long)e.getValue() < System.currentTimeMillis()).forEach(e -> denyList.remove(e.getKey()));
            loopAddress.removeAll(denyList.keySet());
            Collections.shuffle(loopAddress);
            return loopAddress.stream().filter(e -> e.primary == primary).findFirst();
        }
    }
    ,
    NONE(""){

        @Override
        public Optional<HostAddress> getAvailableHost(List<HostAddress> hostAddresses, ConcurrentMap<HostAddress, Long> denyList, boolean primary) {
            return hostAddresses.isEmpty() ? Optional.empty() : Optional.of(hostAddresses.get(0));
        }
    };

    private final String value;

    private HaMode(String value) {
        this.value = value;
    }

    public static HaMode from(String value) {
        for (HaMode haMode : HaMode.values()) {
            if (!haMode.value.equalsIgnoreCase(value) && !haMode.name().equalsIgnoreCase(value)) continue;
            return haMode;
        }
        throw new IllegalArgumentException(String.format("Wrong argument value '%s' for HaMode", value));
    }

    public static Optional<HostAddress> getAvailableHostInOrder(List<HostAddress> hostAddresses, ConcurrentMap<HostAddress, Long> denyList, boolean primary) {
        for (HostAddress hostAddress : hostAddresses) {
            if (hostAddress.primary != primary) continue;
            if (!denyList.containsKey(hostAddress)) {
                return Optional.of(hostAddress);
            }
            if ((Long)denyList.get(hostAddress) >= System.currentTimeMillis()) continue;
            denyList.remove(hostAddress);
            return Optional.of(hostAddress);
        }
        return Optional.empty();
    }

    public abstract Optional<HostAddress> getAvailableHost(List<HostAddress> var1, ConcurrentMap<HostAddress, Long> var2, boolean var3);
}

