package org.mapstruct.ap.internal.gem;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.AbstractAnnotationValueVisitor8;
import javax.lang.model.util.ElementFilter;
import org.mapstruct.tools.gem.Gem;
import org.mapstruct.tools.gem.GemValue;

import javax.lang.model.type.TypeMirror;

public class EnumMappingGem implements Gem {

    private final GemValue<String> nameTransformationStrategy;
    private final GemValue<String> configuration;
    private final GemValue<TypeMirror> unexpectedValueMappingException;
    private final boolean isValid;
    private final AnnotationMirror mirror;

    private EnumMappingGem( BuilderImpl builder ) {
        this.nameTransformationStrategy = builder.nameTransformationStrategy;
        this.configuration = builder.configuration;
        this.unexpectedValueMappingException = builder.unexpectedValueMappingException;
        isValid = ( this.nameTransformationStrategy != null ? this.nameTransformationStrategy.isValid() : false )
               && ( this.configuration != null ? this.configuration.isValid() : false )
               && ( this.unexpectedValueMappingException != null ? this.unexpectedValueMappingException.isValid() : false );
        mirror = builder.mirror;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link EnumMappingGem#nameTransformationStrategy}
    */
    public GemValue<String> nameTransformationStrategy( ) {
        return nameTransformationStrategy;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link EnumMappingGem#configuration}
    */
    public GemValue<String> configuration( ) {
        return configuration;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link EnumMappingGem#unexpectedValueMappingException}
    */
    public GemValue<TypeMirror> unexpectedValueMappingException( ) {
        return unexpectedValueMappingException;
    }

    @Override
    public AnnotationMirror mirror( ) {
        return mirror;
    }

    @Override
    public boolean isValid( ) {
        return isValid;
    }

    public static EnumMappingGem  instanceOn(Element element) {
        return build( element, new BuilderImpl() );
    }

    public static EnumMappingGem instanceOn(AnnotationMirror mirror ) {
        return build( mirror, new BuilderImpl() );
    }

    public static  <T> T  build(Element element, Builder<T> builder) {
        AnnotationMirror mirror = element.getAnnotationMirrors().stream()
            .filter( a ->  "org.mapstruct.EnumMapping".contentEquals( ( ( TypeElement )a.getAnnotationType().asElement() ).getQualifiedName() ) )
            .findAny()
            .orElse( null );
        return build( mirror, builder );
    }

    public static <T> T build(AnnotationMirror mirror, Builder<T> builder ) {

        // return fast
        if ( mirror == null || builder == null ) {
            return null;
        }

        // fetch defaults from all defined values in the annotation type
        List<ExecutableElement> enclosed = ElementFilter.methodsIn( mirror.getAnnotationType().asElement().getEnclosedElements() );
        Map<String, AnnotationValue> defaultValues = new HashMap<>( enclosed.size() );
        enclosed.forEach( e -> defaultValues.put( e.getSimpleName().toString(), e.getDefaultValue() ) );

        // fetch all explicitely set annotation values in the annotation instance
        Map<String, AnnotationValue> values = new HashMap<>( enclosed.size() );
        mirror.getElementValues().entrySet().forEach( e -> values.put( e.getKey().getSimpleName().toString(), e.getValue() ) );

        // iterate and populate builder
        for ( String methodName : defaultValues.keySet() ) {

            if ( "nameTransformationStrategy".equals( methodName ) ) {
                builder.setNametransformationstrategy( GemValue.create( values.get( methodName ), defaultValues.get( methodName ), String.class ) );
            }
            else if ( "configuration".equals( methodName ) ) {
                builder.setConfiguration( GemValue.create( values.get( methodName ), defaultValues.get( methodName ), String.class ) );
            }
            else if ( "unexpectedValueMappingException".equals( methodName ) ) {
                builder.setUnexpectedvaluemappingexception( GemValue.create( values.get( methodName ), defaultValues.get( methodName ), TypeMirror.class ) );
            }
        }
        builder.setMirror( mirror );
        return builder.build();
    }

    /**
     * A builder that can be implemented by the user to define custom logic e.g. in the
     * build method, prior to creating the annotation gem.
     */
    public interface Builder<T> {

       /**
        * Sets the {@link GemValue} for {@link EnumMappingGem#nameTransformationStrategy}
        *
        * @return the {@link Builder} for this gem, representing {@link EnumMappingGem}
        */
        Builder setNametransformationstrategy(GemValue<String> methodName );

       /**
        * Sets the {@link GemValue} for {@link EnumMappingGem#configuration}
        *
        * @return the {@link Builder} for this gem, representing {@link EnumMappingGem}
        */
        Builder setConfiguration(GemValue<String> methodName );

       /**
        * Sets the {@link GemValue} for {@link EnumMappingGem#unexpectedValueMappingException}
        *
        * @return the {@link Builder} for this gem, representing {@link EnumMappingGem}
        */
        Builder setUnexpectedvaluemappingexception(GemValue<TypeMirror> methodName );

        /**
         * Sets the annotation mirror
         *
         * @param mirror the mirror which this gem represents
         *
         * @return the {@link Builder} for this gem, representing {@link EnumMappingGem}
         */
          Builder setMirror( AnnotationMirror mirror );

        /**
         * The build method can be overriden in a custom custom implementation, which allows
         * the user to define his own custom validation on the annotation.
         *
         * @return the representation of the annotation
         */
        T build();
    }

    private static class BuilderImpl implements Builder<EnumMappingGem> {

        private GemValue<String> nameTransformationStrategy;
        private GemValue<String> configuration;
        private GemValue<TypeMirror> unexpectedValueMappingException;
        private AnnotationMirror mirror;

        public Builder setNametransformationstrategy(GemValue<String> nameTransformationStrategy ) {
            this.nameTransformationStrategy = nameTransformationStrategy;
            return this;
        }

        public Builder setConfiguration(GemValue<String> configuration ) {
            this.configuration = configuration;
            return this;
        }

        public Builder setUnexpectedvaluemappingexception(GemValue<TypeMirror> unexpectedValueMappingException ) {
            this.unexpectedValueMappingException = unexpectedValueMappingException;
            return this;
        }

        public Builder  setMirror( AnnotationMirror mirror ) {
            this.mirror = mirror;
            return this;
        }

        public EnumMappingGem build() {
            return new EnumMappingGem( this );
        }
    }

}
