/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.protocols.urp;

import com.sun.star.bridge.InvalidProtocolChangeException;
import com.sun.star.bridge.ProtocolProperty;
import com.sun.star.bridge.XProtocolProperties;
import com.sun.star.lang.DisposedException;
import com.sun.star.lib.uno.environments.remote.IProtocol;
import com.sun.star.lib.uno.environments.remote.Message;
import com.sun.star.lib.uno.environments.remote.ThreadId;
import com.sun.star.lib.uno.protocols.urp.Marshal;
import com.sun.star.lib.uno.protocols.urp.PendingRequests;
import com.sun.star.lib.uno.protocols.urp.Unmarshal;
import com.sun.star.lib.uno.protocols.urp.UrpMessage;
import com.sun.star.lib.uno.typedesc.MethodDescription;
import com.sun.star.lib.uno.typedesc.TypeDescription;
import com.sun.star.uno.Any;
import com.sun.star.uno.IBridge;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.Type;
import com.sun.star.uno.TypeClass;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XCurrentContext;
import com.sun.star.uno.XInterface;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Random;
import java.util.StringTokenizer;

public final class urp
implements IProtocol {
    private static final String PROPERTIES_OID = "UrpProtocolProperties";
    private static final int PROPERTIES_FID_REQUEST_CHANGE = 4;
    private static final String PROPERTIES_FUN_REQUEST_CHANGE = "requestChange";
    private static final int PROPERTIES_FID_COMMIT_CHANGE = 5;
    private static final String PROPERTIES_FUN_COMMIT_CHANGE = "commitChange";
    private static final String PROPERTY_CURRENT_CONTEXT = "CurrentContext";
    private static final short CACHE_SIZE = 256;
    private static final int HEADER_LONGHEADER = 128;
    private static final int HEADER_REQUEST = 64;
    private static final int HEADER_NEWTYPE = 32;
    private static final int HEADER_NEWOID = 16;
    private static final int HEADER_NEWTID = 8;
    private static final int HEADER_FUNCTIONID16 = 4;
    private static final int HEADER_MOREFLAGS = 1;
    private static final int HEADER_MUSTREPLY = 128;
    private static final int HEADER_SYNCHRONOUS = 64;
    private static final int HEADER_FUNCTIONID14 = 64;
    private static final int HEADER_FUNCTIONID = 63;
    private static final int HEADER_EXCEPTION = 32;
    private static final int MAX_FUNCTIONID16 = 65535;
    private static final int MAX_FUNCTIONID14 = 16383;
    private static final int MAX_FUNCTIONID8 = 255;
    private static final int STATE_INITIAL0 = 0;
    private static final int STATE_INITIAL = 1;
    private static final int STATE_REQUESTED = 2;
    private static final int STATE_COMMITTED = 3;
    private static final int STATE_WAIT = 4;
    private static final int STATE_TERMINATED = 5;
    private static final int MAX_RELEASE_QUEUE_SIZE = 100;
    private static final Random randomGenerator = new Random();
    private final DataInput input;
    private final DataOutputStream output;
    private final Marshal marshal;
    private final Unmarshal unmarshal;
    private final boolean forceSynchronous;
    private final PendingRequests pendingIn = new PendingRequests();
    private final PendingRequests pendingOut = new PendingRequests();
    private final Object monitor = new Object();
    private int state = 0;
    private boolean initialized = false;
    private ThreadId propertiesTid = null;
    private int random;
    private boolean currentContext = false;
    private ThreadId inL1Tid = null;
    private String inL1Oid = null;
    private TypeDescription inL1Type = null;
    private ThreadId outL1Tid = null;
    private String outL1Oid = null;
    private TypeDescription outL1Type = null;
    private final ArrayList<QueuedRelease> releaseQueue = new ArrayList();

    public urp(IBridge iBridge, String string, InputStream inputStream, OutputStream outputStream) {
        this.input = new DataInputStream(inputStream);
        this.output = new DataOutputStream(outputStream);
        this.marshal = new Marshal(iBridge, 256);
        this.unmarshal = new Unmarshal(iBridge, 256);
        this.forceSynchronous = urp.parseAttributes(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() throws IOException {
        Object object = this.monitor;
        synchronized (object) {
            if (this.state == 0) {
                this.sendRequestChange();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminate() {
        Object object = this.monitor;
        synchronized (object) {
            this.state = 5;
            this.initialized = true;
            this.monitor.notifyAll();
        }
    }

    @Override
    public Message readMessage() throws IOException {
        UrpMessage urpMessage;
        while (true) {
            int n;
            if (!this.unmarshal.hasMore()) {
                this.unmarshal.reset(this.readBlock());
                if (!this.unmarshal.hasMore()) {
                    throw new IOException("closeConnection message received");
                }
            }
            urpMessage = ((n = this.unmarshal.read8Bit()) & 0x80) != 0 ? ((n & 0x40) != 0 ? this.readLongRequest(n) : this.readReply(n)) : this.readShortRequest(n);
            if (!urpMessage.isInternal()) break;
            this.handleInternalMessage(urpMessage);
        }
        return urpMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeRequest(String string, TypeDescription typeDescription, String string2, ThreadId threadId, Object[] objectArray) throws IOException {
        if (string.equals(PROPERTIES_OID)) {
            throw new IllegalArgumentException("illegal OID " + string);
        }
        Object object = this.monitor;
        synchronized (object) {
            while (!this.initialized) {
                try {
                    this.monitor.wait();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    throw new java.lang.RuntimeException(interruptedException);
                }
            }
            if (this.state == 5) {
                throw new DisposedException();
            }
            return this.writeRequest(false, string, typeDescription, string2, threadId, objectArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeReply(boolean bl, ThreadId threadId, Object object) throws IOException {
        DataOutputStream dataOutputStream = this.output;
        synchronized (dataOutputStream) {
            Object[] objectArray;
            TypeDescription[] typeDescriptionArray;
            TypeDescription typeDescription;
            this.writeQueuedReleases();
            int n = 128;
            PendingRequests.Item item = this.pendingIn.pop(threadId);
            if (bl) {
                n |= 0x20;
                typeDescription = TypeDescription.getTypeDescription((TypeClass)TypeClass.ANY);
                typeDescriptionArray = null;
                objectArray = null;
            } else {
                typeDescription = item.function.getReturnSignature();
                typeDescriptionArray = item.function.getOutSignature();
                objectArray = item.arguments;
            }
            if (!threadId.equals(this.outL1Tid)) {
                n |= 8;
                this.outL1Tid = threadId;
            } else {
                threadId = null;
            }
            this.marshal.write8Bit(n);
            if (threadId != null) {
                this.marshal.writeThreadId(threadId);
            }
            this.marshal.writeValue(typeDescription, object);
            if (typeDescriptionArray != null) {
                for (int i = 0; i < typeDescriptionArray.length; ++i) {
                    if (typeDescriptionArray[i] == null) continue;
                    this.marshal.writeValue(typeDescriptionArray[i].getComponentType(), Array.get(objectArray[i], 0));
                }
            }
            this.writeBlock(true);
        }
    }

    private void sendRequestChange() throws IOException {
        if (this.propertiesTid == null) {
            this.propertiesTid = ThreadId.createFresh();
        }
        this.random = randomGenerator.nextInt();
        this.writeRequest(true, PROPERTIES_OID, TypeDescription.getTypeDescription(XProtocolProperties.class), PROPERTIES_FUN_REQUEST_CHANGE, this.propertiesTid, new Object[]{this.random});
        this.state = 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleInternalMessage(Message message) throws IOException {
        if (message.isRequest()) {
            String string = message.getType().getTypeName();
            if (!string.equals("com.sun.star.bridge.XProtocolProperties")) {
                throw new IOException("read URP protocol properties request with unsupported type " + string);
            }
            int n = message.getMethod().getIndex();
            switch (n) {
                case 4: {
                    this.checkSynchronousPropertyRequest(message);
                    Object object = this.monitor;
                    synchronized (object) {
                        switch (this.state) {
                            case 0: 
                            case 1: {
                                this.writeReply(false, message.getThreadId(), 1);
                                this.state = 4;
                                break;
                            }
                            case 2: {
                                int n2 = (Integer)message.getArguments()[0];
                                if (this.random < n2) {
                                    this.writeReply(false, message.getThreadId(), 1);
                                    this.state = 4;
                                    break;
                                }
                                if (this.random == n2) {
                                    this.writeReply(false, message.getThreadId(), -1);
                                    this.state = 1;
                                    this.sendRequestChange();
                                    break;
                                }
                                this.writeReply(false, message.getThreadId(), 0);
                                break;
                            }
                            default: {
                                this.writeReply(true, message.getThreadId(), (Object)new RuntimeException("read URP protocol properties requestChange request in illegal state"));
                            }
                        }
                        break;
                    }
                }
                case 5: {
                    this.checkSynchronousPropertyRequest(message);
                    Object object = this.monitor;
                    synchronized (object) {
                        if (this.state == 4) {
                            int n3;
                            ProtocolProperty[] protocolPropertyArray = (ProtocolProperty[])message.getArguments()[0];
                            boolean bl = true;
                            boolean bl2 = false;
                            for (n3 = 0; n3 < protocolPropertyArray.length; ++n3) {
                                if (!protocolPropertyArray[n3].Name.equals(PROPERTY_CURRENT_CONTEXT)) {
                                    bl = false;
                                    break;
                                }
                                bl2 = true;
                            }
                            if (bl) {
                                this.writeReply(false, message.getThreadId(), null);
                            } else {
                                this.writeReply(true, message.getThreadId(), new InvalidProtocolChangeException("", null, protocolPropertyArray[n3], 1));
                            }
                            this.state = 1;
                            if (!this.initialized) {
                                if (bl2) {
                                    this.currentContext = true;
                                    this.initialized = true;
                                    this.monitor.notifyAll();
                                } else {
                                    this.sendRequestChange();
                                }
                            }
                        } else {
                            this.writeReply(true, message.getThreadId(), (Object)new RuntimeException("read URP protocol properties commitChange request in illegal state"));
                        }
                        break;
                    }
                }
                default: {
                    throw new IOException("read URP protocol properties request with unsupported function ID " + n);
                }
            }
        } else {
            Object object = this.monitor;
            synchronized (object) {
                if (this.state == 3) {
                    if (!message.isAbnormalTermination()) {
                        this.currentContext = true;
                    }
                    this.state = 1;
                    this.initialized = true;
                    this.monitor.notifyAll();
                } else if (message.isAbnormalTermination()) {
                    this.state = 1;
                    this.initialized = true;
                    this.monitor.notifyAll();
                } else {
                    int n = (Integer)message.getResult();
                    switch (n) {
                        case -1: 
                        case 0: {
                            break;
                        }
                        case 1: {
                            this.writeRequest(true, PROPERTIES_OID, TypeDescription.getTypeDescription(XProtocolProperties.class), PROPERTIES_FUN_COMMIT_CHANGE, this.propertiesTid, new Object[]{new ProtocolProperty[]{new ProtocolProperty(PROPERTY_CURRENT_CONTEXT, (Object)Any.VOID)}});
                            this.state = 3;
                            break;
                        }
                        default: {
                            throw new IOException("read URP protocol properties requestChange reply with illegal return value " + n);
                        }
                    }
                }
            }
        }
    }

    private void checkSynchronousPropertyRequest(Message message) throws IOException {
        if (!message.isSynchronous()) {
            throw new IOException("read URP protocol properties request for synchronous function marked as not SYNCHRONOUS");
        }
    }

    private byte[] readBlock() throws IOException {
        int n = this.input.readInt();
        this.input.readInt();
        byte[] byArray = new byte[n];
        this.input.readFully(byArray);
        return byArray;
    }

    private UrpMessage readLongRequest(int n) throws IOException {
        int n2;
        boolean bl = false;
        if ((n & 1) != 0) {
            if (this.unmarshal.read8Bit() != 192) {
                throw new IOException("read URP request with bad MUSTREPLY/SYNCHRONOUS byte");
            }
            bl = true;
        }
        int n3 = n2 = (n & 4) != 0 ? this.unmarshal.read16Bit() : this.unmarshal.read8Bit();
        if ((n & 0x20) != 0) {
            this.inL1Type = this.unmarshal.readType();
            if (this.inL1Type.getTypeClass() != TypeClass.INTERFACE) {
                throw new IOException("read URP request with non-interface type " + this.inL1Type);
            }
        }
        if ((n & 0x10) != 0) {
            this.inL1Oid = this.unmarshal.readObjectId();
        }
        if ((n & 8) != 0) {
            this.inL1Tid = this.unmarshal.readThreadId();
        }
        return this.readRequest(n2, bl);
    }

    private UrpMessage readShortRequest(int n) throws IOException {
        int n2 = (n & 0x40) != 0 ? (n & 0x3F) << 8 | this.unmarshal.read8Bit() : n & 0x3F;
        return this.readRequest(n2, false);
    }

    private UrpMessage readRequest(int n, boolean bl) throws IOException {
        int n2;
        boolean bl2 = PROPERTIES_OID.equals(this.inL1Oid);
        XCurrentContext xCurrentContext = this.currentContext && !bl2 && n != 2 ? (XCurrentContext)this.unmarshal.readInterface(new Type(XCurrentContext.class)) : null;
        MethodDescription methodDescription = this.inL1Type.getMethodDescription(n);
        if (methodDescription == null) {
            throw new IOException("read URP request with unsupported function ID " + n);
        }
        TypeDescription[] typeDescriptionArray = methodDescription.getInSignature();
        TypeDescription[] typeDescriptionArray2 = methodDescription.getOutSignature();
        Object[] objectArray = new Object[typeDescriptionArray.length];
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            if (typeDescriptionArray[n2] != null) {
                if (typeDescriptionArray2[n2] != null) {
                    Object object = Array.newInstance(typeDescriptionArray2[n2].getComponentType().getZClass(), 1);
                    Array.set(object, 0, this.unmarshal.readValue(typeDescriptionArray2[n2].getComponentType()));
                    objectArray[n2] = object;
                    continue;
                }
                objectArray[n2] = this.unmarshal.readValue(typeDescriptionArray[n2]);
                continue;
            }
            objectArray[n2] = Array.newInstance(typeDescriptionArray2[n2].getComponentType().getZClass(), 1);
        }
        int n3 = n2 = bl || !methodDescription.isOneway() ? 1 : 0;
        if (n2 != 0) {
            this.pendingIn.push(this.inL1Tid, new PendingRequests.Item(bl2, methodDescription, objectArray));
        }
        return new UrpMessage(this.inL1Tid, true, this.inL1Oid, this.inL1Type, methodDescription, n2 != 0, xCurrentContext, false, null, objectArray, bl2);
    }

    private UrpMessage readReply(int n) {
        Object object;
        Object[] objectArray;
        TypeDescription[] typeDescriptionArray;
        TypeDescription typeDescription;
        boolean bl;
        if ((n & 8) != 0) {
            this.inL1Tid = this.unmarshal.readThreadId();
        }
        PendingRequests.Item item = this.pendingOut.pop(this.inL1Tid);
        boolean bl2 = bl = (n & 0x20) != 0;
        if (bl) {
            typeDescription = TypeDescription.getTypeDescription((TypeClass)TypeClass.ANY);
            typeDescriptionArray = null;
            objectArray = null;
        } else {
            typeDescription = item.function.getReturnSignature();
            typeDescriptionArray = item.function.getOutSignature();
            objectArray = item.arguments;
        }
        Object object2 = object = typeDescription == null ? null : this.unmarshal.readValue(typeDescription);
        if (typeDescriptionArray != null) {
            for (int i = 0; i < typeDescriptionArray.length; ++i) {
                if (typeDescriptionArray[i] == null) continue;
                Array.set(objectArray[i], 0, this.unmarshal.readValue(typeDescriptionArray[i].getComponentType()));
            }
        }
        return new UrpMessage(this.inL1Tid, false, null, null, null, false, null, bl, object, objectArray, item.internal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeRequest(boolean bl, String string, TypeDescription typeDescription, String string2, ThreadId threadId, Object[] objectArray) throws IOException {
        MethodDescription methodDescription = typeDescription.getMethodDescription(string2);
        DataOutputStream dataOutputStream = this.output;
        synchronized (dataOutputStream) {
            if (methodDescription.getIndex() == 2 && this.releaseQueue.size() < 100) {
                this.releaseQueue.add(new QueuedRelease(bl, string, typeDescription, methodDescription, threadId));
                return false;
            }
            this.writeQueuedReleases();
            return this.writeRequest(bl, string, typeDescription, methodDescription, threadId, objectArray, true);
        }
    }

    private boolean writeRequest(boolean bl, String string, TypeDescription typeDescription, MethodDescription methodDescription, ThreadId threadId, Object[] objectArray, boolean bl2) throws IOException {
        int n;
        boolean bl3;
        int n2 = methodDescription.getIndex();
        if (n2 < 0 || n2 > 65535) {
            throw new IllegalArgumentException("function ID " + n2 + " out of range");
        }
        boolean bl4 = this.forceSynchronous && n2 != 2;
        boolean bl5 = bl3 = bl4 && methodDescription.isOneway();
        int n3 = 0;
        if (!typeDescription.equals(this.outL1Type)) {
            bl5 = true;
            n3 |= 0x20;
            this.outL1Type = typeDescription;
        } else {
            typeDescription = null;
        }
        if (!string.equals(this.outL1Oid)) {
            bl5 = true;
            n3 |= 0x10;
            this.outL1Oid = string;
        } else {
            string = null;
        }
        if (!threadId.equals(this.outL1Tid)) {
            bl5 = true;
            n3 |= 8;
            this.outL1Tid = threadId;
        } else {
            threadId = null;
        }
        if (n2 > 16383) {
            bl5 = true;
        }
        if (bl5) {
            n3 |= 0xC0;
            if (n2 > 255) {
                n3 |= 4;
            }
            if (bl3) {
                n3 |= 1;
            }
            this.marshal.write8Bit(n3);
            if (bl3) {
                this.marshal.write8Bit(192);
            }
            if (n2 > 255) {
                this.marshal.write16Bit(n2);
            } else {
                this.marshal.write8Bit(n2);
            }
            if (typeDescription != null) {
                this.marshal.writeType(typeDescription);
            }
            if (string != null) {
                this.marshal.writeObjectId(string);
            }
            if (threadId != null) {
                this.marshal.writeThreadId(threadId);
            }
        } else {
            if (n2 > 63) {
                this.marshal.write8Bit(0x40 | n2 >> 8);
            }
            this.marshal.write8Bit(n2);
        }
        if (this.currentContext && !bl && n2 != 2) {
            this.marshal.writeInterface((XInterface)UnoRuntime.getCurrentContext(), new Type(XCurrentContext.class));
        }
        TypeDescription[] typeDescriptionArray = methodDescription.getInSignature();
        TypeDescription[] typeDescriptionArray2 = methodDescription.getOutSignature();
        for (n = 0; n < typeDescriptionArray.length; ++n) {
            if (typeDescriptionArray[n] == null) continue;
            if (typeDescriptionArray2[n] != null) {
                this.marshal.writeValue(typeDescriptionArray2[n].getComponentType(), ((Object[])objectArray[n])[0]);
                continue;
            }
            this.marshal.writeValue(typeDescriptionArray[n], objectArray[n]);
        }
        int n4 = n = bl4 || !methodDescription.isOneway() ? 1 : 0;
        if (n != 0) {
            this.pendingOut.push(this.outL1Tid, new PendingRequests.Item(bl, methodDescription, objectArray));
        }
        this.writeBlock(bl2);
        return n != 0;
    }

    private void writeBlock(boolean bl) throws IOException {
        byte[] byArray = this.marshal.reset();
        this.output.writeInt(byArray.length);
        this.output.writeInt(1);
        this.output.write(byArray);
        if (bl) {
            this.output.flush();
        }
    }

    private void writeQueuedReleases() throws IOException {
        int n = this.releaseQueue.size();
        while (n > 0) {
            QueuedRelease queuedRelease = this.releaseQueue.get(--n);
            this.writeRequest(queuedRelease.internal, queuedRelease.objectId, queuedRelease.type, queuedRelease.method, queuedRelease.threadId, null, false);
            this.releaseQueue.remove(n);
        }
    }

    private static boolean parseAttributes(String string) {
        boolean bl = true;
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                String string3 = null;
                int n = string2.indexOf(61);
                if (n >= 0) {
                    string3 = string2.substring(n + 1);
                    string2 = string2.substring(0, n);
                }
                if (string2.equalsIgnoreCase("ForceSynchronous")) {
                    bl = urp.parseBooleanAttributeValue(string2, string3);
                    continue;
                }
                if (string2.equalsIgnoreCase("negotiate")) {
                    urp.parseBooleanAttributeValue(string2, string3);
                    continue;
                }
                throw new IllegalArgumentException("unknown protocol attribute " + string2);
            }
        }
        return bl;
    }

    private static boolean parseBooleanAttributeValue(String string, String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("missing value for protocol attribute " + string);
        }
        if (string2.equals("0")) {
            return false;
        }
        if (string2.equals("1")) {
            return true;
        }
        throw new IllegalArgumentException("bad value " + string2 + " for protocol attribute " + string);
    }

    private static final class QueuedRelease {
        public final boolean internal;
        public final String objectId;
        public final TypeDescription type;
        public final MethodDescription method;
        public final ThreadId threadId;

        public QueuedRelease(boolean bl, String string, TypeDescription typeDescription, MethodDescription methodDescription, ThreadId threadId) {
            this.internal = bl;
            this.objectId = string;
            this.type = typeDescription;
            this.method = methodDescription;
            this.threadId = threadId;
        }
    }
}

