/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.synthesis.en;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import morfologik.stemming.IStemmer;
import morfologik.stemming.WordData;
import org.languagetool.AnalyzedToken;
import org.languagetool.rules.en.AvsAnRule;
import org.languagetool.synthesis.BaseSynthesizer;

public class EnglishSynthesizer
extends BaseSynthesizer {
    private static final String RESOURCE_FILENAME = "/en/english_synth.dict";
    private static final String TAGS_FILE_NAME = "/en/english_tags.txt";
    private static final String ADD_DETERMINER = "+DT";
    private static final String ADD_IND_DETERMINER = "+INDT";

    public EnglishSynthesizer() {
        super(RESOURCE_FILENAME, TAGS_FILE_NAME);
    }

    public String[] synthesize(AnalyzedToken token, String posTag) throws IOException {
        if (ADD_DETERMINER.equals(posTag)) {
            AvsAnRule rule = new AvsAnRule(null);
            return new String[]{rule.suggestAorAn(token.getToken()), "the " + token.getToken()};
        }
        if (ADD_IND_DETERMINER.equals(posTag)) {
            AvsAnRule rule = new AvsAnRule(null);
            return new String[]{rule.suggestAorAn(token.getToken())};
        }
        IStemmer synthesizer = this.createStemmer();
        List wordData = synthesizer.lookup((CharSequence)(token.getLemma() + "|" + posTag));
        ArrayList<String> wordForms = new ArrayList<String>();
        for (WordData wd : wordData) {
            wordForms.add(wd.getStem().toString());
        }
        return wordForms.toArray(new String[wordForms.size()]);
    }

    public String[] synthesize(AnalyzedToken token, String posTag, boolean posTagRegExp) throws IOException {
        if (posTag != null && posTagRegExp) {
            String myPosTag = posTag;
            String det = "";
            if (posTag.endsWith(ADD_IND_DETERMINER)) {
                myPosTag = myPosTag.substring(0, myPosTag.indexOf(ADD_IND_DETERMINER) - "\\".length());
                AvsAnRule rule = new AvsAnRule(null);
                det = rule.suggestAorAn(token.getLemma());
                det = det.substring(0, det.indexOf(32) + " ".length());
            } else if (posTag.endsWith(ADD_DETERMINER)) {
                myPosTag = myPosTag.substring(0, myPosTag.indexOf(ADD_DETERMINER) - "\\".length());
                det = "the ";
            }
            this.initPossibleTags();
            Pattern p = Pattern.compile(myPosTag);
            ArrayList<String> results = new ArrayList<String>();
            for (String tag : this.possibleTags) {
                Matcher m = p.matcher(tag);
                if (!m.matches()) continue;
                this.lookup(token.getLemma(), tag, results, det);
            }
            return results.toArray(new String[results.size()]);
        }
        return this.synthesize(token, posTag);
    }

    private void lookup(String lemma, String posTag, List<String> results, String determiner) {
        List wordForms = this.getStemmer().lookup((CharSequence)(lemma + "|" + posTag));
        for (WordData wd : wordForms) {
            results.add(determiner + wd.getStem().toString());
        }
    }
}

