/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.client.internal.client;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.kurento.client.Continuation;
import org.kurento.client.Event;
import org.kurento.client.EventListener;
import org.kurento.client.GenericMediaElement;
import org.kurento.client.GenericMediaEvent;
import org.kurento.client.KurentoObject;
import org.kurento.client.Transaction;
import org.kurento.client.internal.ParamAnnotationUtils;
import org.kurento.client.internal.client.DefaultInvocationHandler;
import org.kurento.client.internal.client.ListenerSubscriptionImpl;
import org.kurento.client.internal.client.RemoteObject;
import org.kurento.client.internal.client.RemoteObjectEventListener;
import org.kurento.client.internal.client.RomManager;
import org.kurento.client.internal.server.EventSubscription;
import org.kurento.client.internal.transport.serialization.ParamsFlattener;
import org.kurento.jsonrpc.Props;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteObjectInvocationHandler
extends DefaultInvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(RemoteObjectInvocationHandler.class);
    private static final Set<String> REMOTE_OBJECT_METHODS = ImmutableSet.of((Object)"isCommited", (Object)"waitCommited", (Object)"whenCommited", (Object)"beginTransaction");
    private RemoteObject remoteObject;
    private final RomManager manager;

    public static <E> E newProxy(RemoteObject remoteObject, RomManager manager, Class<E> clazz) {
        RemoteObjectInvocationHandler handler = new RemoteObjectInvocationHandler(remoteObject, manager);
        KurentoObject kurentoObject = (KurentoObject)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)handler);
        remoteObject.setKurentoObject(kurentoObject);
        return (E)kurentoObject;
    }

    public static RemoteObjectInvocationHandler getFor(Object object) {
        return (RemoteObjectInvocationHandler)Proxy.getInvocationHandler(object);
    }

    private RemoteObjectInvocationHandler(RemoteObject remoteObject, RomManager manager) {
        this.remoteObject = remoteObject;
        this.manager = manager;
    }

    @Override
    public Object internalInvoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (REMOTE_OBJECT_METHODS.contains(methodName)) {
            Method remoteObjectMethod = this.findMethod(this.remoteObject, methodName, args);
            return remoteObjectMethod.invoke((Object)this.remoteObject, args);
        }
        Continuation cont = null;
        Transaction tx = null;
        List<String> paramNames = Collections.emptyList();
        if (proxy instanceof GenericMediaElement) {
            switch (method.getName()) {
                case "invoke": {
                    return this.genericMediaElementInvoke(args);
                }
                case "addEventListener": {
                    return this.genericSubscribeEventListener((String)args[0], proxy, args, cont, tx);
                }
                case "removeEventListener": {
                    return this.unsubscribeEventListener(null, args, null, null, cont, tx);
                }
            }
        }
        log.trace("Invoking method {} on object {}", (Object)method, proxy);
        if (args != null && args.length > 0) {
            paramNames = ParamAnnotationUtils.getParamNames(method);
            if (args[args.length - 1] instanceof Continuation) {
                cont = (Continuation)args[args.length - 1];
                args = Arrays.copyOf(args, args.length - 1);
                paramNames = paramNames.subList(0, paramNames.size() - 1);
            } else if (args != null && args.length > 0 && args[0] instanceof Transaction) {
                tx = (Transaction)args[0];
                args = Arrays.copyOfRange(args, 1, args.length);
                paramNames = paramNames.subList(1, paramNames.size());
            }
        }
        if (methodName.equals("release")) {
            return this.release(cont, tx);
        }
        if (method.getAnnotation(EventSubscription.class) != null) {
            EventSubscription eventSubscription = method.getAnnotation(EventSubscription.class);
            if (methodName.startsWith("add")) {
                return this.subscribeEventListener(proxy, args, methodName, eventSubscription.value(), cont, tx);
            }
            if (methodName.startsWith("remove")) {
                return this.unsubscribeEventListener(proxy, args, methodName, eventSubscription.value(), cont, tx);
            }
            throw new IllegalStateException("Method " + methodName + " undefined for events");
        }
        return this.invoke(method, paramNames, args, cont, tx);
    }

    private Object genericMediaElementInvoke(Object[] args) {
        String methodName = (String)args[0];
        Props props = null;
        if (args.length > 1) {
            props = (Props)args[1];
        }
        return this.remoteObject.invoke(methodName, props, JsonElement.class);
    }

    private Object invoke(Method method, List<String> paramNames, Object[] args, Continuation<?> cont, Transaction tx) {
        Props props = ParamAnnotationUtils.extractProps(paramNames, args);
        if (cont != null) {
            Type[] paramTypes = method.getGenericParameterTypes();
            ParameterizedType contType = (ParameterizedType)paramTypes[paramTypes.length - 1];
            Type returnType = contType.getActualTypeArguments()[0];
            this.remoteObject.invoke(method.getName(), props, returnType, cont);
            return null;
        }
        if (tx != null) {
            Type returnType = method.getGenericReturnType();
            if (returnType instanceof ParameterizedType) {
                ParameterizedType futureType = (ParameterizedType)returnType;
                Type methodReturnType = futureType.getActualTypeArguments()[0];
                return this.remoteObject.invoke(method.getName(), props, methodReturnType, tx);
            }
            return this.remoteObject.invoke(method.getName(), props, (Type)((Object)Void.class), tx);
        }
        return this.remoteObject.invoke(method.getName(), props, method.getGenericReturnType());
    }

    private Object release(Continuation<?> cont, Transaction tx) {
        if (cont != null) {
            this.remoteObject.release(cont);
        } else if (tx != null) {
            this.remoteObject.release(tx);
        } else {
            this.remoteObject.release();
        }
        return null;
    }

    private Object subscribeEventListener(final Object proxy, final Object[] args, String methodName, final Class<? extends Event> eventClass, Continuation<?> cont, Transaction tx) {
        String eventName = eventClass.getSimpleName().substring(0, eventClass.getSimpleName().length() - "Event".length());
        RemoteObjectEventListener listener = new RemoteObjectEventListener(){

            @Override
            public void onEvent(String eventType, Props data) {
                RemoteObjectInvocationHandler.this.propagateEventTo(proxy, eventClass, data, (EventListener)args[0]);
            }
        };
        if (cont != null) {
            this.remoteObject.addEventListener(eventName, listener, cont);
            return null;
        }
        if (tx != null) {
            return this.remoteObject.addEventListener(eventName, listener, tx);
        }
        return this.remoteObject.addEventListener(eventName, listener);
    }

    private Object genericSubscribeEventListener(String eventName, final Object proxy, final Object[] args, Continuation<?> cont, Transaction tx) {
        RemoteObjectEventListener listener = new RemoteObjectEventListener(){

            @Override
            public void onEvent(String eventType, Props data) {
                RemoteObjectInvocationHandler.this.propagateEventTo(proxy, GenericMediaEvent.class, data, (EventListener)args[1]);
            }
        };
        if (cont != null) {
            this.remoteObject.addEventListener(eventName, listener, cont);
            return null;
        }
        if (tx != null) {
            return this.remoteObject.addEventListener(eventName, listener, tx);
        }
        return this.remoteObject.addEventListener(eventName, listener);
    }

    private Object unsubscribeEventListener(Object proxy, Object[] args, String methodName, Class<? extends Event> eventClass, Continuation<?> cont, Transaction tx) {
        ListenerSubscriptionImpl listenerSubscription = (ListenerSubscriptionImpl)args[0];
        if (cont != null) {
            this.remoteObject.removeEventListener(listenerSubscription, cont);
        } else if (tx != null) {
            this.remoteObject.removeEventListener(listenerSubscription, tx);
        } else {
            this.remoteObject.removeEventListener(listenerSubscription);
        }
        return null;
    }

    protected void propagateEventTo(Object object, Class<? extends Event> eventClass, Props data, EventListener<?> listener) {
        try {
            log.debug("Event class '" + eventClass.getSimpleName() + " Data: " + data);
            Constructor<?> constructor = eventClass.getConstructors()[0];
            data.add("source", (Object)((KurentoObject)object).getId());
            Object[] params = ParamsFlattener.getInstance().unflattenParams(constructor.getParameterAnnotations(), constructor.getGenericParameterTypes(), data, this.manager);
            Event event = (Event)constructor.newInstance(params);
            listener.onEvent(event);
        }
        catch (Exception e) {
            log.error("Exception while processing event '" + eventClass.getSimpleName() + "' with params '" + data + "'", (Throwable)e);
        }
    }

    public RemoteObject getRemoteObject() {
        return this.remoteObject;
    }

    public void setRemoteObject(RemoteObject remoteObject) {
        this.remoteObject = remoteObject;
    }

    public RomManager getRomManager() {
        return this.manager;
    }

    public String toString() {
        return "[RemoteObject: type=" + this.remoteObject.getType() + " remoteRef=" + this.remoteObject.getObjectRef() + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.remoteObject == null ? 0 : this.remoteObject.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        RemoteObjectInvocationHandler other = RemoteObjectInvocationHandler.getFor(obj);
        if (other == null) {
            return false;
        }
        return !(this.remoteObject == null ? other.remoteObject != null : !this.remoteObject.equals(other.remoteObject));
    }
}

