/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.jelly;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.XMLOutput;
import org.kohsuke.stapler.framework.adjunct.AdjunctManager;
import org.kohsuke.stapler.framework.adjunct.AdjunctsInPage;
import org.kohsuke.stapler.jelly.AbstractStaplerTag;
import org.xml.sax.SAXException;

public class AdjunctTag
extends AbstractStaplerTag {
    private String[] includes;
    private String[] assumes;
    private static final Logger LOGGER = Logger.getLogger(AdjunctTag.class.getName());

    public void setIncludes(String _includes) {
        this.includes = this.parse(_includes);
    }

    public void setAssumes(String _assumes) {
        this.assumes = this.parse(_assumes);
    }

    private String[] parse(String s) {
        String[] r = s.split(",");
        for (int i = 0; i < r.length; ++i) {
            r[i] = r[i].trim();
        }
        return r;
    }

    public void doTag(XMLOutput out) throws JellyTagException {
        AdjunctManager m = AdjunctManager.get(this.getServletContext());
        if (m == null) {
            LOGGER.log(Level.WARNING, "AdjunctManager is not installed for this application. Skipping <adjunct> tags", new Exception());
            return;
        }
        try {
            AdjunctsInPage a = AdjunctsInPage.get();
            if (this.assumes != null) {
                a.assumeIncluded(this.assumes);
            }
            if (this.includes != null) {
                a.generate(out, this.includes);
            }
        }
        catch (IOException | SAXException e) {
            throw new JellyTagException((Throwable)e);
        }
    }
}

