/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.framework.adjunct;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.XMLOutput;
import org.kohsuke.stapler.MetaClassLoader;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.WebApp;
import org.kohsuke.stapler.framework.adjunct.AdjunctManager;
import org.kohsuke.stapler.framework.adjunct.NoSuchAdjunctException;
import org.kohsuke.stapler.jelly.JellyClassLoaderTearOff;
import org.kohsuke.stapler.jelly.JellyFacet;
import org.xml.sax.SAXException;

public class Adjunct {
    public final AdjunctManager manager;
    public final String name;
    public final String slashedName;
    public final String packageName;
    public final List<String> required = new ArrayList<String>();
    private final boolean hasCss;
    private final boolean hasJavaScript;
    private final String inclusionFragment;
    private final Script script;
    private static final Pattern INCLUDE = Pattern.compile("/[/*]\\s*@include (\\S+)");
    private static final Pattern HTML_INCLUDE = Pattern.compile("<@include (\\S+)>");

    public Adjunct(AdjunctManager manager, String name, ClassLoader classLoader) throws IOException {
        this.manager = manager;
        this.name = name;
        this.slashedName = name.replace('.', '/');
        this.packageName = this.slashedName.substring(0, Math.max(0, this.slashedName.lastIndexOf(47)));
        this.hasCss = this.parseOne(classLoader, this.slashedName + ".css");
        this.hasJavaScript = this.parseOne(classLoader, this.slashedName + ".js");
        this.inclusionFragment = this.parseHtml(classLoader, this.slashedName + ".html");
        URL jelly = classLoader.getResource(this.slashedName + ".jelly");
        if (jelly != null) {
            try {
                this.script = ((JellyClassLoaderTearOff)MetaClassLoader.get((ClassLoader)classLoader).loadTearOff(JellyClassLoaderTearOff.class)).createContext().compileScript(jelly);
            }
            catch (JellyException e) {
                throw new IOException("Failed to load " + jelly, e);
            }
        } else {
            this.script = null;
        }
        if (!this.hasCss && !this.hasJavaScript && this.inclusionFragment == null && this.script == null) {
            throw new NoSuchAdjunctException("Neither " + name + ".css, .js, .html, nor .jelly were found");
        }
    }

    public String getPackageUrl() {
        return this.getPackageUrl(Stapler.getCurrentRequest());
    }

    private String getPackageUrl(StaplerRequest req) {
        return req.getContextPath() + "/" + this.manager.rootURL + "/" + this.packageName;
    }

    private String getBaseName(StaplerRequest req) {
        return req.getContextPath() + "/" + this.manager.rootURL + "/" + this.slashedName;
    }

    private boolean parseOne(ClassLoader classLoader, String resName) throws IOException {
        String line;
        InputStream is = classLoader.getResourceAsStream(resName);
        if (is == null) {
            return false;
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        while ((line = in.readLine()) != null) {
            Matcher m = INCLUDE.matcher(line);
            if (!m.lookingAt()) continue;
            this.required.add(m.group(1));
        }
        in.close();
        return true;
    }

    private String parseHtml(ClassLoader classLoader, String resName) throws IOException {
        String line;
        InputStream is = classLoader.getResourceAsStream(resName);
        if (is == null) {
            return null;
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        StringBuilder buf = new StringBuilder();
        while ((line = in.readLine()) != null) {
            Matcher m = HTML_INCLUDE.matcher(line);
            if (m.lookingAt()) {
                this.required.add(m.group(1));
                continue;
            }
            buf.append(line).append('\n');
        }
        in.close();
        return buf.toString();
    }

    public boolean has(Kind k) {
        switch (k) {
            case CSS: {
                return this.hasCss;
            }
            case JS: {
                return this.hasJavaScript;
            }
        }
        throw new AssertionError((Object)k);
    }

    public void write(StaplerRequest req, XMLOutput out) throws SAXException, IOException {
        if (this.inclusionFragment != null) {
            out.write(this.inclusionFragment);
            return;
        }
        if (this.script != null) {
            try {
                ((JellyFacet)WebApp.getCurrent().getFacet(JellyFacet.class)).scriptInvoker.invokeScript(req, Stapler.getCurrentResponse(), this.script, this, out);
            }
            catch (JellyTagException e) {
                throw new IOException("Failed to execute Jelly script for adjunct " + this.name, e);
            }
        }
        if (this.hasCss) {
            out.write("<link rel='stylesheet' href='" + this.getBaseName(req) + ".css' type='text/css' />");
        }
        if (this.hasJavaScript) {
            out.write("<script src='" + this.getBaseName(req) + ".js' type='text/javascript'></script>");
        }
    }

    public static enum Kind {
        CSS,
        JS;

    }
}

