/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.authorization.cip;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.keycloak.adapters.authorization.cip.spi.ClaimInformationPointProvider;
import org.keycloak.adapters.authorization.spi.HttpRequest;
import org.keycloak.adapters.authorization.util.PlaceHolders;

public class ClaimsInformationPointProvider
implements ClaimInformationPointProvider {
    private final Map<String, Object> config;

    public ClaimsInformationPointProvider(Map<String, Object> config) {
        this.config = config;
    }

    @Override
    public Map<String, List<String>> resolve(HttpRequest request) {
        HashMap<String, List<String>> claims = new HashMap<String, List<String>>();
        for (Map.Entry<String, Object> configEntry : this.config.entrySet()) {
            String claimName = configEntry.getKey();
            Object claimValue = configEntry.getValue();
            List<Object> values = new ArrayList();
            if (claimValue instanceof String) {
                values = this.getValues(claimValue.toString(), request);
            } else if (claimValue instanceof Collection) {
                for (Object value : (Collection)Collection.class.cast(claimValue)) {
                    List<String> resolvedValues = this.getValues(value.toString(), request);
                    if (resolvedValues.isEmpty()) continue;
                    values.addAll(resolvedValues);
                }
            }
            if (values.isEmpty()) continue;
            claims.put(claimName, values);
        }
        return claims;
    }

    private List<String> getValues(String value, HttpRequest httpFacade) {
        return PlaceHolders.resolve(value, httpFacade);
    }
}

