/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaAccessibleObject;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.ParameterTypes;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.cli.Options;

public abstract class JavaCallable
extends JavaAccessibleObject
implements ParameterTypes {
    protected final Class<?>[] parameterTypes;
    private static final boolean REWRITE_JAVA_TRACE = (Boolean)Options.REWRITE_JAVA_TRACE.load();

    protected JavaCallable(Ruby runtime2, RubyClass rubyClass, Class<?>[] parameterTypes) {
        super(runtime2, rubyClass);
        this.parameterTypes = parameterTypes;
    }

    public static void registerRubyMethods(Ruby runtime2, RubyClass result2) {
        result2.defineAnnotatedMethods(JavaCallable.class);
    }

    @Override
    public final int getArity() {
        return this.parameterTypes.length;
    }

    @Override
    public final Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    public abstract int getModifiers();

    @Override
    public abstract Class<?>[] getExceptionTypes();

    public abstract Type[] getGenericExceptionTypes();

    public abstract Type[] getGenericParameterTypes();

    public abstract Annotation[][] getParameterAnnotations();

    @Override
    public abstract boolean isVarArgs();

    public abstract String toGenericString();

    @JRubyMethod
    public final RubyFixnum arity(ThreadContext context) {
        return context.runtime.newFixnum(this.getArity());
    }

    @JRubyMethod(name={"argument_types", "parameter_types"})
    public final RubyArray parameter_types(ThreadContext context) {
        return JavaClass.toRubyArray(context.runtime, this.getParameterTypes());
    }

    @JRubyMethod
    public RubyArray exception_types(ThreadContext context) {
        return JavaClass.toRubyArray(context.runtime, this.getExceptionTypes());
    }

    @JRubyMethod
    public IRubyObject generic_parameter_types(ThreadContext context) {
        return Java.getInstance(context.runtime, this.getGenericParameterTypes());
    }

    @JRubyMethod
    public IRubyObject generic_exception_types(ThreadContext context) {
        return Java.getInstance(context.runtime, this.getGenericExceptionTypes());
    }

    @JRubyMethod
    public IRubyObject parameter_annotations(ThreadContext context) {
        return Java.getInstance(context.runtime, this.getParameterAnnotations());
    }

    @JRubyMethod(name={"varargs?"})
    public RubyBoolean varargs_p(ThreadContext context) {
        return context.runtime.newBoolean(this.isVarArgs());
    }

    @JRubyMethod
    public RubyString to_generic_string(ThreadContext context) {
        return context.runtime.newString(this.toGenericString());
    }

    @JRubyMethod(name={"public?"})
    public RubyBoolean public_p(ThreadContext context) {
        return RubyBoolean.newBoolean(context.runtime, Modifier.isPublic(this.getModifiers()));
    }

    protected final void checkArity(ThreadContext context, int length2) {
        if (length2 != this.getArity()) {
            throw context.runtime.newArgumentError(length2, this.getArity());
        }
    }

    final Object[] convertArguments(IRubyObject[] args2) {
        return JavaUtil.convertArguments(args2, this.parameterTypes, 0);
    }

    final Object[] convertArguments(IRubyObject[] args2, int offset2) {
        return JavaUtil.convertArguments(args2, this.parameterTypes, offset2);
    }

    protected final IRubyObject handleThrowable(ThreadContext context, Throwable ex) {
        if (ex instanceof JumpException) {
            throw (JumpException)ex;
        }
        if (REWRITE_JAVA_TRACE) {
            Helpers.rewriteStackTraceAndThrow(context, ex);
        }
        Helpers.throwException(ex);
        return null;
    }

    protected final IRubyObject handleInvocationTargetEx(ThreadContext context, InvocationTargetException ex) {
        return this.handleThrowable(context, ex.getTargetException());
    }

    final IRubyObject handleIllegalAccessEx(ThreadContext context, IllegalAccessException ex, Member target) throws RaiseException {
        throw context.runtime.newTypeError("illegal access on '" + target.getName() + "': " + ex.getMessage());
    }

    final IRubyObject handleIllegalAccessEx(ThreadContext context, IllegalAccessException ex, Constructor target) throws RaiseException {
        throw context.runtime.newTypeError("illegal access on constructor for type '" + target.getDeclaringClass().getSimpleName() + "': " + ex.getMessage());
    }

    final IRubyObject handlelIllegalArgumentEx(ThreadContext context, IllegalArgumentException ex, Method target, Object ... arguments) throws RaiseException {
        StringBuilder msg = new StringBuilder(64);
        msg.append("for method ").append(target.getDeclaringClass().getSimpleName()).append('.').append(target.getName());
        msg.append(" expected ");
        this.dumpParameterTypes(msg);
        msg.append("; got: ");
        JavaCallable.dumpArgTypes(arguments, msg);
        msg.append("; error: ").append(ex.getMessage());
        throw context.runtime.newTypeError(msg.toString());
    }

    final IRubyObject handlelIllegalArgumentEx(ThreadContext context, IllegalArgumentException ex, Constructor target, Object ... arguments) throws RaiseException {
        return this.handlelIllegalArgumentEx(context, ex, target, true, arguments);
    }

    final IRubyObject handlelIllegalArgumentEx(ThreadContext context, IllegalArgumentException ex, Constructor target, boolean targetInfo, Object ... arguments) throws RaiseException {
        StringBuilder msg = new StringBuilder(64);
        if (targetInfo) {
            msg.append("for constructor of type ").append(target.getDeclaringClass().getSimpleName());
        }
        msg.append(" expected ");
        this.dumpParameterTypes(msg);
        msg.append("; got: ");
        JavaCallable.dumpArgTypes(arguments, msg);
        msg.append("; error: ").append(ex.getMessage());
        throw context.runtime.newTypeError(msg.toString());
    }

    private void dumpParameterTypes(StringBuilder str) {
        str.append('[');
        JavaCallable.inspectParameterTypes(str, this, false);
        str.append(']');
    }

    static CharSequence dumpArgTypes(Object[] args2, StringBuilder str) {
        str.append('[');
        for (int i2 = 0; i2 < args2.length; ++i2) {
            if (i2 > 0) {
                str.append(',');
            }
            if (args2[i2] == null) {
                str.append("null");
                continue;
            }
            str.append(args2[i2].getClass().getName());
        }
        str.append(']');
        return str;
    }

    public static StringBuilder inspectParameterTypes(StringBuilder str, ParameterTypes target) {
        return JavaCallable.inspectParameterTypes(str, target, true);
    }

    private static StringBuilder inspectParameterTypes(StringBuilder str, ParameterTypes target, boolean brackets) {
        if (brackets) {
            str.append('(');
        }
        Class<?>[] types = target.getParameterTypes();
        for (int i2 = 0; i2 < types.length; ++i2) {
            str.append(types[i2].getName());
            if (i2 >= types.length - 1) continue;
            str.append(',');
        }
        if (brackets) {
            str.append(')');
        }
        return str;
    }
}

