/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets.indy;

import org.jruby.ir.targets.BranchCompiler;
import org.jruby.ir.targets.IRBytecodeAdapter;
import org.jruby.ir.targets.indy.Bootstrap;
import org.jruby.ir.targets.simple.NormalBranchCompiler;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;
import org.objectweb.asm.Label;

public class IndyBranchCompiler
implements BranchCompiler {
    private final IRBytecodeAdapter compiler;
    private final BranchCompiler normalCompiler;

    public IndyBranchCompiler(IRBytecodeAdapter compiler) {
        this.compiler = compiler;
        this.normalCompiler = new NormalBranchCompiler(compiler);
    }

    @Override
    public void branchIfNil(Label label2) {
        this.compiler.adapter.invokedynamic("isNil", CodegenUtils.sig(Boolean.TYPE, IRubyObject.class), Bootstrap.isNilBoot(), new Object[0]);
        this.compiler.adapter.iftrue(label2);
    }

    @Override
    public void branchIfTruthy(Label label2) {
        this.compiler.adapter.invokedynamic("isTrue", CodegenUtils.sig(Boolean.TYPE, IRubyObject.class), Bootstrap.isTrueBoot(), new Object[0]);
        this.compiler.adapter.iftrue(label2);
    }

    @Override
    public void bfalse(Label label2) {
        this.normalCompiler.bfalse(label2);
    }

    @Override
    public void btrue(Label label2) {
        this.normalCompiler.btrue(label2);
    }
}

