/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions"})
@XmlRootElement(name="Con", namespace="http://www.dmg.org/PMML-4_2")
public class Connection
extends PMMLObject
implements HasExtensions {
    @XmlAttribute(name="from", required=true)
    protected String from;
    @XmlAttribute(name="weight", required=true)
    protected double weight;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_2")
    protected List<Extension> extensions;

    public Connection() {
    }

    public Connection(String from, double weight) {
        this.from = from;
        this.weight = weight;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String value) {
        this.from = value;
    }

    public double getWeight() {
        return this.weight;
    }

    public void setWeight(double value) {
        this.weight = value;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public Connection withFrom(String value) {
        this.setFrom(value);
        return this;
    }

    public Connection withWeight(double value) {
        this.setWeight(value);
        return this;
    }

    public Connection withExtensions(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtensions().add(value);
            }
        }
        return this;
    }

    public Connection withExtensions(Collection<Extension> values) {
        if (values != null) {
            this.getExtensions().addAll(values);
        }
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        visitor.pushParent(this);
        for (int i = 0; status == VisitorAction.CONTINUE && this.extensions != null && i < this.extensions.size(); ++i) {
            status = this.extensions.get(i).accept(visitor);
        }
        visitor.popParent();
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

