/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.general_regression;

import org.dmg.pmml.general_regression.GeneralRegressionModel;
import org.jpmml.evaluator.Value;

public class GeneralRegressionModelUtil {
    private GeneralRegressionModelUtil() {
    }

    public static <V extends Number> Value<V> computeLink(GeneralRegressionModel.LinkFunction linkFunction, Double distParameter, Double linkParameter, Value<V> value) {
        switch (linkFunction) {
            case CLOGLOG: {
                return value.inverseCloglog();
            }
            case IDENTITY: {
                return value;
            }
            case LOG: {
                return value.exp();
            }
            case LOGC: {
                return value.inverseLogc();
            }
            case LOGIT: {
                return value.inverseLogit();
            }
            case LOGLOG: {
                return value.inverseLoglog();
            }
            case NEGBIN: {
                if (distParameter == null) {
                    throw new IllegalArgumentException();
                }
                return value.inverseNegbin(distParameter);
            }
            case ODDSPOWER: {
                if (linkParameter == null) {
                    throw new IllegalArgumentException();
                }
                return value.inverseOddspower(linkParameter);
            }
            case POWER: {
                if (linkParameter == null) {
                    throw new IllegalArgumentException();
                }
                return value.inversePower(linkParameter);
            }
            case PROBIT: {
                return value.inverseProbit();
            }
        }
        throw new IllegalArgumentException();
    }

    public static <V extends Number> Value<V> computeCumulativeLink(GeneralRegressionModel.CumulativeLinkFunction cumulativeLinkFunction, Value<V> value) {
        switch (cumulativeLinkFunction) {
            case LOGIT: {
                return value.inverseLogit();
            }
            case PROBIT: {
                return value.inverseProbit();
            }
            case CLOGLOG: {
                return value.inverseCloglog();
            }
            case LOGLOG: {
                return value.inverseLoglog();
            }
            case CAUCHIT: {
                return value.inverseCauchit();
            }
        }
        throw new IllegalArgumentException();
    }
}

