/*
 * Decompiled with CFR 0.152.
 */
package jodd.csselly.selector;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jodd.csselly.CSSellyException;
import jodd.csselly.Selector;
import jodd.csselly.selector.PseudoFunction;
import jodd.csselly.selector.PseudoFunctions;
import jodd.lagarto.dom.Node;
import jodd.lagarto.dom.NodeFilter;
import jodd.lagarto.dom.NodeListFilter;
import jodd.util.ClassUtil;

public class PseudoFunctionSelector<E>
extends Selector
implements NodeFilter,
NodeListFilter {
    protected static final Map<String, PseudoFunction> PSEUDO_FUNCTION_MAP = new HashMap<String, PseudoFunction>(8);
    protected final PseudoFunction<E> pseudoFunction;
    protected final String expression;
    protected final E parsedExpression;

    public static void registerPseudoFunction(Class<? extends PseudoFunction> pseudoFunctionType) {
        PseudoFunction pseudoFunction;
        try {
            pseudoFunction = (PseudoFunction)ClassUtil.newInstance(pseudoFunctionType);
        }
        catch (Exception ex) {
            throw new CSSellyException(ex);
        }
        PSEUDO_FUNCTION_MAP.put(pseudoFunction.getPseudoFunctionName(), pseudoFunction);
    }

    public static PseudoFunction<?> lookupPseudoFunction(String pseudoFunctionName) {
        PseudoFunction pseudoFunction = PSEUDO_FUNCTION_MAP.get(pseudoFunctionName);
        if (pseudoFunction == null) {
            throw new CSSellyException("Unsupported pseudo function: " + pseudoFunctionName);
        }
        return pseudoFunction;
    }

    public PseudoFunctionSelector(String functionName, String expression) {
        super(Selector.Type.PSEUDO_FUNCTION);
        this.pseudoFunction = PseudoFunctionSelector.lookupPseudoFunction(functionName.trim());
        this.expression = expression;
        this.parsedExpression = this.pseudoFunction.parseExpression(expression);
    }

    public PseudoFunction<E> getPseudoFunction() {
        return this.pseudoFunction;
    }

    public String getExpression() {
        return this.expression;
    }

    public E getParsedExpression() {
        return this.parsedExpression;
    }

    @Override
    public boolean accept(Node node) {
        return this.pseudoFunction.match(node, this.parsedExpression);
    }

    @Override
    public boolean accept(List<Node> currentResults, Node node, int index) {
        return this.pseudoFunction.matchInRange(currentResults, node, index, this.parsedExpression);
    }

    static {
        PseudoFunctionSelector.registerPseudoFunction(PseudoFunctions.NTH_CHILD.class);
        PseudoFunctionSelector.registerPseudoFunction(PseudoFunctions.NTH_LAST_CHILD.class);
        PseudoFunctionSelector.registerPseudoFunction(PseudoFunctions.NTH_LAST_OF_TYPE.class);
        PseudoFunctionSelector.registerPseudoFunction(PseudoFunctions.NTH_OF_TYPE.class);
        PseudoFunctionSelector.registerPseudoFunction(PseudoFunctions.EQ.class);
        PseudoFunctionSelector.registerPseudoFunction(PseudoFunctions.GT.class);
        PseudoFunctionSelector.registerPseudoFunction(PseudoFunctions.LT.class);
        PseudoFunctionSelector.registerPseudoFunction(PseudoFunctions.CONTAINS.class);
        PseudoFunctionSelector.registerPseudoFunction(PseudoFunctions.HAS.class);
        PseudoFunctionSelector.registerPseudoFunction(PseudoFunctions.NOT.class);
    }
}

