/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.boot.autoconfigure;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.jodconverter.boot.autoconfigure.JodConverterRemoteProperties;
import org.jodconverter.core.DocumentConverter;
import org.jodconverter.core.office.OfficeManager;
import org.jodconverter.core.util.AssertUtils;
import org.jodconverter.remote.RemoteConverter;
import org.jodconverter.remote.office.RemoteOfficeManager;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnClass(value={RemoteConverter.class})
@ConditionalOnProperty(prefix="jodconverter.remote", name={"enabled"}, havingValue="true")
@EnableConfigurationProperties(value={JodConverterRemoteProperties.class})
public class JodConverterRemoteAutoConfiguration {
    private final JodConverterRemoteProperties properties;

    public JodConverterRemoteAutoConfiguration(@NonNull JodConverterRemoteProperties properties) {
        this.properties = properties;
    }

    private OfficeManager createOfficeManager() {
        AssertUtils.notNull((Object)this.properties.getUrl(), (String)"urlConnection is required");
        RemoteOfficeManager.Builder builder = (RemoteOfficeManager.Builder)((RemoteOfficeManager.Builder)((RemoteOfficeManager.Builder)RemoteOfficeManager.builder().urlConnection(this.properties.getUrl()).connectTimeout(Long.valueOf(this.properties.getConnectTimeout())).socketTimeout(Long.valueOf(this.properties.getSocketTimeout())).poolSize(Integer.valueOf(this.properties.getPoolSize())).workingDir(this.properties.getWorkingDir())).taskQueueTimeout(Long.valueOf(this.properties.getTaskQueueTimeout()))).taskExecutionTimeout(Long.valueOf(this.properties.getTaskExecutionTimeout()));
        if (this.properties.getSsl() != null) {
            builder.sslConfig(this.properties.getSsl().sslConfig());
        }
        return builder.build();
    }

    @Bean(initMethod="start", destroyMethod="stop")
    @ConditionalOnMissingBean(name={"remoteOfficeManager"})
    OfficeManager remoteOfficeManager() {
        return this.createOfficeManager();
    }

    @Bean
    @ConditionalOnMissingBean(name={"remoteDocumentConverter"})
    @ConditionalOnBean(name={"remoteOfficeManager"})
    DocumentConverter remoteDocumentConverter(OfficeManager remoteOfficeManager) {
        return RemoteConverter.make((OfficeManager)remoteOfficeManager);
    }
}

