/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.local.process;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jodconverter.local.process.LinesPumpStreamHandler;
import org.jodconverter.local.process.ProcessManager;
import org.jodconverter.local.process.ProcessQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProcessManager
implements ProcessManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractProcessManager.class);

    protected AbstractProcessManager() {
    }

    @Override
    public boolean canFindPid() {
        return true;
    }

    private String buildOutput(List<String> lines) {
        Objects.requireNonNull(lines, "lines must not be null");
        return lines.stream().filter(StringUtils::isNotBlank).collect(Collectors.joining("\n"));
    }

    protected @NonNull List<@NonNull String> execute(@NonNull String[] cmdarray) throws IOException {
        Process process = Runtime.getRuntime().exec(cmdarray);
        LinesPumpStreamHandler streamsHandler = new LinesPumpStreamHandler(process.getInputStream(), process.getErrorStream());
        streamsHandler.start();
        try {
            process.waitFor();
            streamsHandler.stop();
        }
        catch (InterruptedException ex) {
            LOGGER.warn("The current thread was interrupted while waiting for command execution output.", (Throwable)ex);
            Thread.currentThread().interrupt();
        }
        List<String> outLines = streamsHandler.getOutputPumper().getLines();
        if (LOGGER.isTraceEnabled()) {
            String out = this.buildOutput(outLines);
            String err = this.buildOutput(streamsHandler.getErrorPumper().getLines());
            if (!StringUtils.isBlank((CharSequence)out)) {
                LOGGER.trace("Command Output: {}", (Object)out);
            }
            if (!StringUtils.isBlank((CharSequence)err)) {
                LOGGER.trace("Command Error: {}", (Object)err);
            }
        }
        return outLines;
    }

    @Override
    public long findPid(@NonNull ProcessQuery query) throws IOException {
        Pattern commandPattern = Pattern.compile(Pattern.quote(query.getCommand()) + ".*" + Pattern.quote(query.getArgument()));
        Pattern processLinePattern = this.getRunningProcessLinePattern();
        String[] currentProcessesCommand = this.getRunningProcessesCommand(query.getCommand());
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Finding PID using\nCommand to get current running processes: {}\nRegex used to match current running process lines: {}\nRegex used to match running office process we are looking for: {}", new Object[]{currentProcessesCommand, processLinePattern.pattern(), commandPattern.pattern()});
        }
        List<String> lines = this.execute(currentProcessesCommand);
        for (String line : lines) {
            Matcher commandMatcher;
            if (StringUtils.isBlank((CharSequence)line)) continue;
            LOGGER.trace("Checking if process line matches the process line regex\nProcess line: {}", (Object)line);
            Matcher lineMatcher = processLinePattern.matcher(line);
            if (!lineMatcher.matches()) continue;
            String pid = lineMatcher.group("Pid");
            String commandLine = lineMatcher.group("CommandLine");
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Line matches!\npid: {}; Command line: {}\nChecking if this command line matches the office command line regex", (Object)pid, (Object)commandLine);
            }
            if (!(commandMatcher = commandPattern.matcher(commandLine)).find()) continue;
            LOGGER.debug("Command line matches! Returning pid: {}", (Object)pid);
            return Long.parseLong(pid);
        }
        LOGGER.debug("No matching command line found! Returning pid: NOT_FOUND");
        return -2L;
    }

    protected abstract @NonNull String[] getRunningProcessesCommand(String var1);

    protected abstract @NonNull Pattern getRunningProcessLinePattern();
}

