/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.local;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jodconverter.core.document.DefaultDocumentFormatRegistry;
import org.jodconverter.core.document.DocumentFormatRegistry;
import org.jodconverter.core.job.AbstractConversionJob;
import org.jodconverter.core.job.AbstractConversionJobWithSourceFormatUnspecified;
import org.jodconverter.core.job.AbstractConverter;
import org.jodconverter.core.job.AbstractSourceDocumentSpecs;
import org.jodconverter.core.job.AbstractTargetDocumentSpecs;
import org.jodconverter.core.job.SourceDocumentSpecs;
import org.jodconverter.core.job.TargetDocumentSpecs;
import org.jodconverter.core.office.InstalledOfficeManagerHolder;
import org.jodconverter.core.office.OfficeException;
import org.jodconverter.core.office.OfficeManager;
import org.jodconverter.core.task.OfficeTask;
import org.jodconverter.local.filter.DefaultFilterChain;
import org.jodconverter.local.filter.Filter;
import org.jodconverter.local.filter.FilterChain;
import org.jodconverter.local.task.LocalConversionTask;

public class LocalConverter
extends AbstractConverter {
    public static final Map<String, Object> DEFAULT_LOAD_PROPERTIES;
    private Map<String, Object> loadProperties;
    private FilterChain filterChain;
    private final Map<String, Object> storeProperties;

    public static @NonNull Builder builder() {
        return new Builder();
    }

    public static @NonNull LocalConverter make() {
        return LocalConverter.builder().build();
    }

    public static @NonNull LocalConverter make(@NonNull OfficeManager officeManager) {
        return ((Builder)LocalConverter.builder().officeManager(officeManager)).build();
    }

    private LocalConverter(OfficeManager officeManager, DocumentFormatRegistry formatRegistry, Map<String, Object> loadProperties, FilterChain filterChain, Map<String, Object> storeProperties) {
        super(officeManager, formatRegistry);
        this.loadProperties = loadProperties;
        this.filterChain = filterChain;
        this.storeProperties = storeProperties;
    }

    protected @NonNull AbstractConversionJobWithSourceFormatUnspecified convert(@NonNull AbstractSourceDocumentSpecs source) {
        return new LocalConversionJobWithSourceFormatUnspecified(source);
    }

    static {
        HashMap<String, Comparable<Boolean>> loadProperties = new HashMap<String, Comparable<Boolean>>();
        loadProperties.put("Hidden", Boolean.valueOf(true));
        loadProperties.put("ReadOnly", Boolean.valueOf(true));
        loadProperties.put("UpdateDocMode", Short.valueOf((short)1));
        DEFAULT_LOAD_PROPERTIES = Collections.unmodifiableMap(loadProperties);
    }

    public static final class Builder
    extends AbstractConverter.AbstractConverterBuilder<Builder> {
        private Map<String, Object> loadProperties;
        private FilterChain filterChain;
        private Map<String, Object> storeProperties;

        private Builder() {
        }

        public @NonNull LocalConverter build() {
            OfficeManager manager = this.officeManager;
            if (manager == null && (manager = InstalledOfficeManagerHolder.getInstance()) == null) {
                throw new IllegalStateException("An office manager is required in order to build a converter.");
            }
            return new LocalConverter(manager, this.formatRegistry == null ? DefaultDocumentFormatRegistry.getInstance() : this.formatRegistry, this.loadProperties, this.filterChain, this.storeProperties);
        }

        public @NonNull Builder filterChain(Filter ... filters) {
            Validate.notEmpty((Object[])filters, (String)"filters must not be null nor empty", (Object[])new Object[0]);
            this.filterChain = new DefaultFilterChain(filters);
            return this;
        }

        public @NonNull Builder filterChain(@NonNull FilterChain filterChain) {
            Validate.notNull((Object)filterChain, (String)"filterChain must not be null", (Object[])new Object[0]);
            this.filterChain = filterChain;
            return this;
        }

        public @NonNull Builder loadProperties(@NonNull Map<@NonNull String, @NonNull Object> loadProperties) {
            Validate.notNull(loadProperties, (String)"loadProperties must not be null", (Object[])new Object[0]);
            this.loadProperties = loadProperties;
            return this;
        }

        public @NonNull Builder storeProperties(@NonNull Map<@NonNull String, @NonNull Object> storeProperties) {
            Validate.notNull(storeProperties, (String)"storeProperties must not be null", (Object[])new Object[0]);
            this.storeProperties = storeProperties;
            return this;
        }
    }

    private class LocalConversionJob
    extends AbstractConversionJob {
        private LocalConversionJob(AbstractSourceDocumentSpecs source, AbstractTargetDocumentSpecs target) {
            super(source, target);
        }

        public void doExecute() throws OfficeException {
            LocalConversionTask task = new LocalConversionTask((SourceDocumentSpecs)this.source, (TargetDocumentSpecs)this.target, LocalConverter.this.loadProperties, LocalConverter.this.filterChain, LocalConverter.this.storeProperties);
            LocalConverter.this.officeManager.execute((OfficeTask)task);
        }
    }

    private class LocalConversionJobWithSourceFormatUnspecified
    extends AbstractConversionJobWithSourceFormatUnspecified {
        private LocalConversionJobWithSourceFormatUnspecified(AbstractSourceDocumentSpecs source) {
            super(source, LocalConverter.this.officeManager, LocalConverter.this.formatRegistry);
        }

        protected @NonNull AbstractConversionJob to(@NonNull AbstractTargetDocumentSpecs target) {
            return new LocalConversionJob(this.source, target);
        }
    }
}

