/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.task;

import com.sun.star.frame.XStorable;
import com.sun.star.io.IOException;
import com.sun.star.lang.XComponent;
import com.sun.star.task.ErrorCodeIOException;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.Validate;
import org.jodconverter.document.DocumentFormat;
import org.jodconverter.filter.FilterChain;
import org.jodconverter.filter.RefreshFilter;
import org.jodconverter.job.DocumentSpecs;
import org.jodconverter.job.SourceDocumentSpecs;
import org.jodconverter.job.TargetDocumentSpecs;
import org.jodconverter.office.LocalOfficeContext;
import org.jodconverter.office.LocalOfficeUtils;
import org.jodconverter.office.OfficeContext;
import org.jodconverter.office.OfficeException;
import org.jodconverter.office.utils.Lo;
import org.jodconverter.task.AbstractLocalOfficeTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalConversionTask
extends AbstractLocalOfficeTask {
    private static final String ERROR_MESSAGE_STORE = "Could not store document: ";
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalConversionTask.class);
    private final TargetDocumentSpecs target;
    private final FilterChain filterChain;
    private final Map<String, Object> storeProperties;

    public LocalConversionTask(SourceDocumentSpecs source, TargetDocumentSpecs target, Map<String, Object> loadProperties, FilterChain filterChain, Map<String, Object> storeProperties) {
        super(source, loadProperties);
        this.target = target;
        this.filterChain = Optional.ofNullable(filterChain).map(FilterChain::copy).orElse(RefreshFilter.CHAIN);
        this.storeProperties = storeProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(OfficeContext context) throws OfficeException {
        LOGGER.info("Executing local conversion task [{} -> {}]...", (Object)Optional.of(this.source).map(DocumentSpecs::getFormat).map(DocumentFormat::getExtension).orElse("?"), (Object)Optional.of(this.target).map(DocumentSpecs::getFormat).map(DocumentFormat::getExtension).orElse("?"));
        LocalOfficeContext localContext = (LocalOfficeContext)context;
        File sourceFile = this.source.getFile();
        try {
            File targetFile = this.target.getFile();
            XComponent document = null;
            try {
                document = this.loadDocument(localContext, sourceFile);
                this.modifyDocument(context, document);
                this.storeDocument(document, targetFile);
                this.target.onComplete(targetFile);
            }
            catch (OfficeException officeEx) {
                LOGGER.error("Local conversion failed.", (Throwable)officeEx);
                this.target.onFailure(targetFile, (Exception)((Object)officeEx));
                throw officeEx;
            }
            catch (Exception ex) {
                LOGGER.error("Local conversion failed.", (Throwable)ex);
                OfficeException officeEx = new OfficeException("Local conversion failed", (Throwable)ex);
                this.target.onFailure(targetFile, (Exception)((Object)officeEx));
                throw officeEx;
            }
            finally {
                this.closeDocument(document);
            }
        }
        finally {
            this.source.onConsumed(sourceFile);
        }
    }

    private Map<String, Object> getStoreProperties(XComponent document) throws OfficeException {
        HashMap<String, Object> storeProps = new HashMap<String, Object>();
        LocalConversionTask.appendProperties(storeProps, this.target.getFormat().getStoreProperties(LocalOfficeUtils.getDocumentFamily(document)));
        LocalConversionTask.appendProperties(storeProps, this.storeProperties);
        return storeProps;
    }

    protected void modifyDocument(OfficeContext context, XComponent document) throws OfficeException {
        this.filterChain.doFilter(context, document);
    }

    protected void storeDocument(XComponent document, File targetFile) throws OfficeException {
        Map<String, Object> storeProps = this.getStoreProperties(document);
        Validate.isTrue((boolean)storeProps.containsKey("FilterName"), (String)"Unsupported conversion", (Object[])new Object[0]);
        try {
            Lo.qi(XStorable.class, document).storeToURL(LocalOfficeUtils.toUrl(targetFile), LocalOfficeUtils.toUnoProperties(storeProps));
        }
        catch (ErrorCodeIOException errorCodeIoEx) {
            throw new OfficeException(ERROR_MESSAGE_STORE + targetFile.getName() + "; errorCode: " + errorCodeIoEx.ErrCode, (Throwable)errorCodeIoEx);
        }
        catch (IOException ioEx) {
            throw new OfficeException(ERROR_MESSAGE_STORE + targetFile.getName(), (Throwable)ioEx);
        }
    }

    @Override
    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "{source=" + this.source + ", loadProperties=" + this.loadProperties + ", target=" + this.target + ", storeProperties=" + this.storeProperties + '}';
    }
}

