/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.office;

import java.io.IOException;
import org.apache.commons.lang3.SystemUtils;
import org.jodconverter.office.AbstractRetryable;
import org.jodconverter.office.OfficeException;
import org.jodconverter.office.OfficeProcessConfig;
import org.jodconverter.office.TemporaryException;
import org.jodconverter.office.VerboseProcess;
import org.jodconverter.process.ProcessManager;
import org.jodconverter.process.ProcessQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartProcessRetryable
extends AbstractRetryable<Exception> {
    private static final int FIND_PID_RETRIES = 10;
    private static final long FIND_PID_DELAY = 2000L;
    private static final long FIND_PID_INTERVAL = 250L;
    private static final Integer EXIT_CODE_81 = 81;
    private static final Logger LOGGER = LoggerFactory.getLogger(StartProcessRetryable.class);
    private final OfficeProcessConfig processConfig;
    private final ProcessBuilder processBuilder;
    private final ProcessQuery processQuery;
    private VerboseProcess process;
    private Integer exitCode = null;
    private long processId = -1L;

    public StartProcessRetryable(OfficeProcessConfig processConfig, ProcessBuilder processBuilder, ProcessQuery processQuery) {
        this.processConfig = processConfig;
        this.processBuilder = processBuilder;
        this.processQuery = processQuery;
    }

    protected void attempt() throws Exception {
        this.exitCode = null;
        this.processId = -1L;
        this.process = new VerboseProcess(this.processBuilder.start());
        ProcessManager processManager = this.processConfig.getProcessManager();
        if (SystemUtils.IS_OS_FREE_BSD) {
            LOGGER.debug("Waiting for process to start on FreeBSD...");
            this.sleep(2000L);
        }
        this.tryFindPid(processManager);
        if (this.exitCode != null) {
            if (this.exitCode.equals(EXIT_CODE_81)) {
                LOGGER.warn("Office process died with exit code 81; restarting it");
                throw new TemporaryException("Office process died with exit code 81");
            }
            throw new OfficeException("Office process died with exit code: " + this.exitCode);
        }
        if (processManager.canFindPid() && this.processId <= -1L) {
            try {
                this.process.getProcess().destroy();
            }
            catch (Exception ex) {
                LOGGER.warn("Unable to destroy the process", (Throwable)ex);
            }
            throw new TemporaryException(String.format("A process with acceptString '%s' started but its pid could not be found; restarting it", this.processQuery.getArgument()));
        }
    }

    public VerboseProcess getProcess() {
        return this.process;
    }

    public long getProcessId() {
        return this.processId;
    }

    private void tryFindPid(ProcessManager processManager) throws IOException {
        int tryCount = 0;
        while (true) {
            LOGGER.debug("Trying to find pid, attempt #{}", (Object)(++tryCount));
            try {
                this.exitCode = this.process.getProcess().exitValue();
                return;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                if (!processManager.canFindPid()) {
                    LOGGER.debug("The current process manager does not support finding the pid: {}", (Object)processManager.getClass().getName());
                    return;
                }
                this.processId = processManager.findPid(this.processQuery);
                if (this.processId > -1L || tryCount == 10) {
                    return;
                }
                this.sleep(250L);
                continue;
            }
            break;
        }
    }

    private void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

