/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.office;

import org.jodconverter.office.AbstractRetryable;
import org.jodconverter.office.OfficeConnection;
import org.jodconverter.office.OfficeConnectionException;
import org.jodconverter.office.OfficeException;
import org.jodconverter.office.OfficeProcess;
import org.jodconverter.office.TemporaryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectRetryable
extends AbstractRetryable<OfficeException> {
    private static final Integer EXIT_CODE_81 = 81;
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectRetryable.class);
    private final OfficeProcess process;
    private final OfficeConnection connection;

    public ConnectRetryable(OfficeConnection connection) {
        this(null, connection);
    }

    public ConnectRetryable(OfficeProcess process, OfficeConnection connection) {
        this.process = process;
        this.connection = connection;
    }

    protected void attempt() throws TemporaryException, OfficeException {
        try {
            this.connection.connect();
        }
        catch (OfficeConnectionException ex) {
            if (this.process == null) {
                throw new TemporaryException((Throwable)((Object)ex));
            }
            Integer exitCode = this.process.getExitCode();
            if (exitCode == null) {
                throw new TemporaryException((Throwable)((Object)ex));
            }
            if (exitCode.equals(EXIT_CODE_81)) {
                LOGGER.warn("Office process died with exit code 81; restarting it");
                this.process.start(true);
                throw new TemporaryException((Throwable)((Object)ex));
            }
            throw new OfficeException("Office process died with exit code " + exitCode, (Throwable)((Object)ex));
        }
    }
}

