/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.filter.text;

import com.sun.star.beans.PropertyValue;
import com.sun.star.document.XDocumentInsertable;
import com.sun.star.lang.XComponent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import java.io.File;
import org.jodconverter.filter.Filter;
import org.jodconverter.filter.FilterChain;
import org.jodconverter.office.LocalOfficeUtils;
import org.jodconverter.office.OfficeContext;
import org.jodconverter.office.utils.Lo;
import org.jodconverter.office.utils.Write;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentInserterFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentInserterFilter.class);
    private final File documentToInsert;

    public DocumentInserterFilter(File document) {
        this.documentToInsert = document;
    }

    @Override
    public void doFilter(OfficeContext context, XComponent document, FilterChain chain) throws Exception {
        LOGGER.debug("Applying the DocumentInserterFilter");
        if (Write.isText(document)) {
            this.insertDocument(document);
        }
        chain.doFilter(context, document);
    }

    private void insertDocument(XComponent document) throws Exception {
        XTextDocument docText = Write.getTextDoc(document);
        XTextCursor textCursor = docText.getText().createTextCursor();
        textCursor.gotoEnd(false);
        XDocumentInsertable insertable = Lo.qi(XDocumentInsertable.class, textCursor);
        insertable.insertDocumentFromURL(LocalOfficeUtils.toUrl(this.documentToInsert), new PropertyValue[0]);
    }
}

