/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.filter.text;

import com.sun.star.awt.Size;
import com.sun.star.frame.XController;
import com.sun.star.text.TextContentAnchorType;
import com.sun.star.text.WrapTextMode;
import com.sun.star.text.XPageCursor;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextRange;
import com.sun.star.text.XTextViewCursor;
import com.sun.star.text.XTextViewCursorSupplier;
import java.awt.Dimension;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jodconverter.filter.Filter;
import org.jodconverter.office.utils.Lo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTextContentInserterFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTextContentInserterFilter.class);
    private final Dimension rectSize;
    private final Map<String, Object> shapeProperties;

    public static Map<String, Object> createDefaultShapeProperties(int horizontalPosition, int verticalPosition) {
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("AnchorType", TextContentAnchorType.AT_PAGE);
        props.put("HoriOrient", (short)0);
        props.put("HoriOrientPosition", horizontalPosition * 100);
        props.put("HoriOrientRelation", (short)7);
        props.put("VertOrient", (short)0);
        props.put("VertOrientPosition", verticalPosition * 100);
        props.put("VertOrientRelation", (short)7);
        props.put("Surround", WrapTextMode.THROUGHT);
        return props;
    }

    public static Size toOfficeSize(Dimension size) {
        return new Size(size.width * 100, size.height * 100);
    }

    public AbstractTextContentInserterFilter(Dimension size, int horizontalPosition, int verticalPosition) {
        this.rectSize = new Dimension(size.width, size.height);
        this.shapeProperties = AbstractTextContentInserterFilter.createDefaultShapeProperties(horizontalPosition, verticalPosition);
    }

    public AbstractTextContentInserterFilter(Dimension size, Map<String, Object> shapeProperties) {
        this.rectSize = new Dimension(size.width, size.height);
        this.shapeProperties = new LinkedHashMap<String, Object>(shapeProperties);
    }

    protected void applyAnchorPageNoFix(XTextDocument docText, XTextCursor textCursor) {
        Object anchorPageNo = this.shapeProperties.get("AnchorPageNo");
        if (anchorPageNo != null) {
            LOGGER.debug("Applying AnchorPageNo fix");
            XController controller = docText.getCurrentController();
            XTextViewCursor viewCursor = Lo.qi(XTextViewCursorSupplier.class, controller).getViewCursor();
            XPageCursor pageCursor = Lo.qi(XPageCursor.class, viewCursor);
            pageCursor.jumpToPage(Short.parseShort(anchorPageNo.toString()));
            textCursor.gotoRange((XTextRange)viewCursor, false);
        }
    }

    public Dimension getRectSize() {
        return this.rectSize;
    }

    public Map<String, Object> getShapeProperties() {
        return this.shapeProperties;
    }
}

