/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.filter;

import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNamed;
import com.sun.star.datatransfer.XTransferable;
import com.sun.star.datatransfer.XTransferableSupplier;
import com.sun.star.drawing.XDrawPage;
import com.sun.star.drawing.XDrawPages;
import com.sun.star.drawing.XDrawPagesSupplier;
import com.sun.star.frame.XController;
import com.sun.star.lang.XComponent;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XSpreadsheets;
import com.sun.star.text.XPageCursor;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextViewCursor;
import com.sun.star.text.XTextViewCursorSupplier;
import com.sun.star.view.XSelectionSupplier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.Validate;
import org.jodconverter.filter.Filter;
import org.jodconverter.filter.FilterChain;
import org.jodconverter.office.OfficeContext;
import org.jodconverter.office.utils.Calc;
import org.jodconverter.office.utils.Draw;
import org.jodconverter.office.utils.Lo;
import org.jodconverter.office.utils.Props;
import org.jodconverter.office.utils.Write;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PagesSelectorFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PagesSelectorFilter.class);
    private final List<Integer> pages;

    public PagesSelectorFilter(Integer ... pages) {
        this(Stream.of(pages).collect(Collectors.toSet()));
    }

    public PagesSelectorFilter(Set<Integer> pages) {
        Validate.notEmpty(pages);
        this.pages = new ArrayList<Integer>(pages);
    }

    @Override
    public void doFilter(OfficeContext context, XComponent document, FilterChain chain) throws Exception {
        if (Write.isText(document)) {
            LOGGER.debug("Applying the PagesSelectorFilter for a Text document");
            Collections.sort(this.pages);
            this.selectTextPages(document);
        } else if (Calc.isCalc(document)) {
            LOGGER.debug("Applying the PagesSelectorFilter for a Calc document");
            this.selectSheets(document);
        } else if (Draw.isImpress(document)) {
            LOGGER.debug("Applying the PagesSelectorFilter for an Impress document");
            this.pages.sort(Collections.reverseOrder());
            this.selectDrawPages(document);
        } else if (Draw.isDraw(document)) {
            LOGGER.debug("Applying the PagesSelectorFilter for a Draw document");
            this.pages.sort(Collections.reverseOrder());
            this.selectDrawPages(document);
        }
        chain.doFilter(context, document);
    }

    private void copyPage(XTextDocument docText, int source, int target) throws Exception {
        if (source == target) {
            return;
        }
        XController ctrl = docText.getCurrentController();
        XTextCursor tc = docText.getText().createTextCursor();
        XTextViewCursor vc = Lo.qi(XTextViewCursorSupplier.class, ctrl).getViewCursor();
        XPageCursor pc = Lo.qi(XPageCursor.class, vc);
        tc.gotoStart(false);
        vc.gotoStart(false);
        pc.jumpToPage((short)source);
        tc.gotoRange(vc.getStart(), false);
        pc.jumpToEndOfPage();
        tc.gotoRange(vc.getStart(), true);
        XSelectionSupplier selectionSupplier = Lo.qi(XSelectionSupplier.class, ctrl);
        selectionSupplier.select((Object)tc);
        XTransferableSupplier transferableSupplier = Lo.qi(XTransferableSupplier.class, ctrl);
        XTransferable xTransferable = transferableSupplier.getTransferable();
        tc.gotoStart(false);
        vc.gotoStart(false);
        pc.jumpToPage((short)target);
        tc.gotoRange(vc.getStart(), false);
        pc.jumpToEndOfPage();
        tc.gotoRange(vc.getStart(), true);
        selectionSupplier.select((Object)tc);
        transferableSupplier.insertTransferable(xTransferable);
    }

    private void selectTextPages(XComponent document) throws Exception {
        XTextDocument doc = Write.getTextDoc(document);
        XController ctrl = doc.getCurrentController();
        int pageCount = (Integer)Props.getProperty(ctrl, "PageCount").orElse(0);
        int nextTargetPage = 1;
        for (int page : this.pages) {
            if (page <= 0 || page > pageCount) continue;
            this.copyPage(doc, page, nextTargetPage++);
        }
        int lastPage = nextTargetPage - 1;
        XTextCursor tc = doc.getText().createTextCursor();
        XTextViewCursor vc = Lo.qi(XTextViewCursorSupplier.class, ctrl).getViewCursor();
        XPageCursor pc = Lo.qi(XPageCursor.class, vc);
        tc.gotoStart(false);
        vc.gotoStart(false);
        pc.jumpToPage((short)lastPage);
        pc.jumpToEndOfPage();
        tc.gotoRange(vc.getEnd(), true);
        XSelectionSupplier selectionSupplier = Lo.qi(XSelectionSupplier.class, ctrl);
        selectionSupplier.select((Object)tc);
        XTransferableSupplier transSupplier = Lo.qi(XTransferableSupplier.class, ctrl);
        XTransferable trans = transSupplier.getTransferable();
        tc.gotoStart(false);
        tc.gotoEnd(true);
        selectionSupplier.select((Object)tc);
        transSupplier.insertTransferable(trans);
    }

    private void selectSheets(XComponent document) throws Exception {
        XSpreadsheetDocument doc = Calc.getCalcDoc(document);
        XSpreadsheets sheets = doc.getSheets();
        XIndexAccess indexedSheets = Lo.qi(XIndexAccess.class, sheets);
        int count = indexedSheets.getCount();
        for (int i = count - 1; i >= 0; --i) {
            XSpreadsheet sheet = Lo.qi(XSpreadsheet.class, indexedSheets.getByIndex(i));
            XNamed namedSheet = Lo.qi(XNamed.class, sheet);
            if (this.pages.contains(i + 1)) continue;
            sheets.removeByName(namedSheet.getName());
        }
    }

    private void selectDrawPages(XComponent document) throws Exception {
        int pageCount;
        XDrawPages drawPages = Lo.qi(XDrawPagesSupplier.class, document).getDrawPages();
        for (int i = pageCount = drawPages.getCount(); i > 0; --i) {
            if (this.pages.contains(i)) continue;
            drawPages.remove(Lo.qi(XDrawPage.class, drawPages.getByIndex(i - 1)));
        }
    }
}

