/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.office;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.jodconverter.office.ExitCodeRetryable;
import org.jodconverter.office.LocalOfficeUtils;
import org.jodconverter.office.OfficeDescriptor;
import org.jodconverter.office.OfficeException;
import org.jodconverter.office.OfficeProcessConfig;
import org.jodconverter.office.OfficeUrl;
import org.jodconverter.office.RetryTimeoutException;
import org.jodconverter.office.VerboseProcess;
import org.jodconverter.process.LinesPumpStreamHandler;
import org.jodconverter.process.ProcessManager;
import org.jodconverter.process.ProcessQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OfficeProcess {
    private static final Logger LOGGER = LoggerFactory.getLogger(OfficeProcess.class);
    private VerboseProcess process;
    private OfficeDescriptor descriptor;
    private long pid = -1L;
    private final OfficeUrl officeUrl;
    private final OfficeProcessConfig config;
    private final File instanceProfileDir;

    public OfficeProcess(OfficeUrl officeUrl) {
        this(officeUrl, new OfficeProcessConfig());
    }

    public OfficeProcess(OfficeUrl officeUrl, OfficeProcessConfig config) {
        this.officeUrl = officeUrl;
        this.config = config;
        this.instanceProfileDir = this.getInstanceProfileDir();
    }

    private void checkForExistingProcess(ProcessQuery processQuery) throws OfficeException {
        try {
            ProcessManager processManager = this.config.getProcessManager();
            long existingPid = processManager.findPid(processQuery);
            if (existingPid != -2L && existingPid != -1L && this.config.isKillExistingProcess()) {
                LOGGER.warn("A process with acceptString '{}' is already running; pid {}", (Object)processQuery.getArgument(), (Object)existingPid);
                processManager.kill(null, existingPid);
                this.waitForProcessToDie();
                existingPid = processManager.findPid(processQuery);
            }
            if (existingPid != -2L && existingPid != -1L) {
                throw new OfficeException(String.format("A process with acceptString '%s' is already running; pid %d", processQuery.getArgument(), existingPid));
            }
        }
        catch (IOException ioEx) {
            throw new OfficeException(String.format("Unable to check if there is already an existing process with acceptString '%s'", processQuery.getArgument()), (Throwable)ioEx);
        }
    }

    public void deleteInstanceProfileDir() {
        LOGGER.debug("Deleting instance profile directory '{}'", (Object)this.instanceProfileDir);
        try {
            FileUtils.deleteDirectory((File)this.instanceProfileDir);
        }
        catch (IOException ioEx) {
            File oldProfileDir = new File(this.instanceProfileDir.getParentFile(), this.instanceProfileDir.getName() + ".old." + System.currentTimeMillis());
            if (this.instanceProfileDir.renameTo(oldProfileDir)) {
                LOGGER.warn("Could not delete profileDir: {}; renamed it to {}", (Object)ioEx.getMessage(), (Object)oldProfileDir);
            }
            LOGGER.error("Could not delete profileDir: {}", (Object)ioEx.getMessage());
        }
    }

    private void detectOfficeVersion() {
        ArrayList<String> command = new ArrayList<String>();
        File executable = LocalOfficeUtils.getOfficeExecutable(this.config.getOfficeHome());
        if (this.config.getRunAsArgs() != null) {
            command.addAll(Arrays.asList(this.config.getRunAsArgs()));
        }
        String execPath = executable.getAbsolutePath();
        this.descriptor = OfficeDescriptor.fromExecutablePath(execPath);
        String prefix = this.descriptor.useLongOptionNameGnuStyle() ? "--" : "-";
        command.add(execPath);
        command.add(prefix + "invisible");
        command.add(prefix + "help");
        command.add(prefix + "headless");
        command.add(prefix + "nocrashreport");
        command.add(prefix + "nodefault");
        command.add(prefix + "nofirststartwizard");
        command.add(prefix + "nolockcheck");
        command.add(prefix + "nologo");
        command.add(prefix + "norestore");
        command.add("-env:UserInstallation=" + LocalOfficeUtils.toUrl(this.instanceProfileDir));
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        try {
            Process process = processBuilder.start();
            LinesPumpStreamHandler handler = new LinesPumpStreamHandler(process.getInputStream(), process.getErrorStream());
            handler.start();
            try {
                process.waitFor();
                handler.stop();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.descriptor = OfficeDescriptor.fromHelpOutput(handler.getOutputPumper().getLines());
        }
        catch (IOException ioEx) {
            LOGGER.warn("An I/O error prevents us to determine office version", (Throwable)ioEx);
        }
    }

    public int forciblyTerminate(long retryInterval, long retryTimeout) throws OfficeException, RetryTimeoutException {
        if (this.process == null) {
            return 0;
        }
        LOGGER.info("Trying to forcibly terminate process: '{}'; pid: {}", (Object)this.officeUrl.getConnectionParametersAsString(), this.pid == -1L ? "NA" : Long.valueOf(this.pid));
        try {
            this.config.getProcessManager().kill(this.process.getProcess(), this.pid);
            return this.getExitCode(retryInterval, retryTimeout);
        }
        catch (IOException ioEx) {
            throw new OfficeException("Unable to kill the process with pid: " + this.pid, (Throwable)ioEx);
        }
    }

    public Integer getExitCode() {
        if (this.process == null) {
            return 0;
        }
        return this.process.getExitCode();
    }

    public int getExitCode(long retryInterval, long retryTimeout) throws OfficeException, RetryTimeoutException {
        if (this.process == null) {
            return 0;
        }
        try {
            ExitCodeRetryable retryable = new ExitCodeRetryable(this.process);
            retryable.execute(retryInterval, retryTimeout);
            return retryable.getExitCode();
        }
        catch (RetryTimeoutException retryTimeoutEx) {
            throw retryTimeoutEx;
        }
        catch (Exception ex) {
            throw new OfficeException("Could not get the process exit code", (Throwable)ex);
        }
    }

    private File getInstanceProfileDir() {
        return new File(this.config.getWorkingDir(), ".jodconverter_" + this.officeUrl.getConnectionAndParametersAsString().replace(',', '_').replace('=', '-'));
    }

    public boolean isRunning() {
        return this.process != null && this.getExitCode() == null;
    }

    private void prepareInstanceProfileDir() throws OfficeException {
        if (this.instanceProfileDir.exists()) {
            LOGGER.warn("Profile dir '{}' already exists; deleting", (Object)this.instanceProfileDir);
            this.deleteInstanceProfileDir();
        }
        if (this.config.getTemplateProfileDir() != null) {
            try {
                FileUtils.copyDirectory((File)this.config.getTemplateProfileDir(), (File)this.instanceProfileDir);
            }
            catch (IOException ioEx) {
                throw new OfficeException("Failed to create the instance profile directory", (Throwable)ioEx);
            }
        }
    }

    private ProcessBuilder prepareProcessBuilder(String acceptString) {
        ArrayList<String> command = new ArrayList<String>();
        File executable = LocalOfficeUtils.getOfficeExecutable(this.config.getOfficeHome());
        if (this.config.getRunAsArgs() != null) {
            command.addAll(Arrays.asList(this.config.getRunAsArgs()));
        }
        String execPath = executable.getAbsolutePath();
        String prefix = this.descriptor.useLongOptionNameGnuStyle() ? "--" : "-";
        command.add(execPath);
        command.add(prefix + "accept=" + acceptString);
        command.add(prefix + "headless");
        command.add(prefix + "invisible");
        command.add(prefix + "nocrashreport");
        command.add(prefix + "nodefault");
        command.add(prefix + "nofirststartwizard");
        command.add(prefix + "nolockcheck");
        command.add(prefix + "nologo");
        command.add(prefix + "norestore");
        command.add("-env:UserInstallation=" + LocalOfficeUtils.toUrl(this.instanceProfileDir));
        return new ProcessBuilder(command);
    }

    public void start() throws OfficeException {
        this.start(false);
    }

    public void start(boolean restart) throws OfficeException {
        String acceptString = this.officeUrl.getConnectionAndParametersAsString() + ";" + this.officeUrl.getProtocolAndParametersAsString() + ";" + this.officeUrl.getRootOid();
        ProcessQuery processQuery = new ProcessQuery("soffice", acceptString);
        this.checkForExistingProcess(processQuery);
        if (!restart) {
            this.prepareInstanceProfileDir();
        }
        this.detectOfficeVersion();
        ProcessBuilder processBuilder = this.prepareProcessBuilder(acceptString);
        LOGGER.info("Starting process with acceptString '{}' and profileDir '{}'", (Object)acceptString, (Object)this.instanceProfileDir);
        try {
            this.process = new VerboseProcess(processBuilder.start());
            this.pid = this.config.getProcessManager().findPid(processQuery);
            LOGGER.info("Started process{}", (Object)(this.pid == -1L ? "" : "; pid = " + this.pid));
        }
        catch (IOException ioEx) {
            throw new OfficeException(String.format("An I/O error prevents us to start a process with acceptString '%s'", acceptString), (Throwable)ioEx);
        }
        if (this.pid == -2L) {
            throw new OfficeException(String.format("A process with acceptString '%s' started but its pid could not be found", acceptString));
        }
    }

    private void waitForProcessToDie() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }
}

