/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.office;

import java.io.File;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.jodconverter.office.AbstractOfficeManagerPool;
import org.jodconverter.office.InstalledOfficeManagerHolder;
import org.jodconverter.office.LocalOfficeUtils;
import org.jodconverter.office.OfficeManager;
import org.jodconverter.office.OfficeManagerPoolConfig;
import org.jodconverter.office.OfficeProcessManagerPoolConfig;
import org.jodconverter.office.OfficeProcessManagerPoolEntry;
import org.jodconverter.office.OfficeUrl;
import org.jodconverter.process.ProcessManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LocalOfficeManager
extends AbstractOfficeManagerPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalOfficeManager.class);
    private final OfficeUrl[] officeUrls;

    public static Builder builder() {
        return new Builder();
    }

    public static LocalOfficeManager make() {
        return LocalOfficeManager.builder().build();
    }

    public static LocalOfficeManager install() {
        return ((Builder)LocalOfficeManager.builder().install()).build();
    }

    private LocalOfficeManager(OfficeUrl[] officeUrls, OfficeProcessManagerPoolConfig config) {
        super(officeUrls.length, (OfficeManagerPoolConfig)config);
        this.officeUrls = Arrays.copyOf(officeUrls, officeUrls.length);
    }

    protected OfficeProcessManagerPoolEntry[] createPoolEntries() {
        return (OfficeProcessManagerPoolEntry[])Arrays.stream(this.officeUrls).map(officeUrl -> new OfficeProcessManagerPoolEntry((OfficeUrl)officeUrl, (OfficeProcessManagerPoolConfig)this.config)).toArray(OfficeProcessManagerPoolEntry[]::new);
    }

    public static final class Builder
    extends AbstractOfficeManagerPool.AbstractOfficeManagerPoolBuilder<Builder> {
        private String[] pipeNames;
        private int[] portNumbers;
        private File officeHome;
        private ProcessManager processManager;
        private String[] runAsArgs;
        private File templateProfileDir;
        private boolean useDefaultOnInvalidTemplateProfileDir;
        private boolean killExistingProcess = true;
        private long processTimeout = 120000L;
        private long processRetryInterval = 250L;
        private int maxTasksPerProcess = 200;
        private boolean disableOpengl = false;

        private Builder() {
        }

        public LocalOfficeManager build() {
            if (this.officeHome == null) {
                this.officeHome = LocalOfficeUtils.getDefaultOfficeHome();
            }
            if (this.workingDir == null) {
                this.workingDir = new File(System.getProperty("java.io.tmpdir"));
            }
            if (this.processManager == null) {
                this.processManager = LocalOfficeUtils.findBestProcessManager();
            }
            LocalOfficeUtils.validateOfficeHome(this.officeHome);
            LocalOfficeUtils.validateOfficeWorkingDirectory(this.workingDir);
            if (this.useDefaultOnInvalidTemplateProfileDir) {
                try {
                    LocalOfficeUtils.validateOfficeTemplateProfileDirectory(this.templateProfileDir);
                }
                catch (IllegalStateException ex) {
                    this.templateProfileDir = null;
                    LOGGER.warn("Falling back to default templateProfileDir. Cause: ", (Object)ex.getMessage());
                }
            } else {
                LocalOfficeUtils.validateOfficeTemplateProfileDirectory(this.templateProfileDir);
            }
            OfficeUrl[] officeUrls = LocalOfficeUtils.buildOfficeUrls(this.portNumbers, this.pipeNames);
            OfficeProcessManagerPoolConfig config = new OfficeProcessManagerPoolConfig(this.officeHome, this.workingDir, this.processManager);
            config.setRunAsArgs(this.runAsArgs);
            config.setTemplateProfileDir(this.templateProfileDir);
            config.setKillExistingProcess(this.killExistingProcess);
            config.setProcessTimeout(this.processTimeout);
            config.setProcessRetryInterval(this.processRetryInterval);
            config.setMaxTasksPerProcess(this.maxTasksPerProcess);
            config.setDisableOpengl(this.disableOpengl);
            config.setTaskExecutionTimeout(this.taskExecutionTimeout);
            config.setTaskQueueTimeout(this.taskQueueTimeout);
            LocalOfficeManager manager = new LocalOfficeManager(officeUrls, config);
            if (this.install) {
                InstalledOfficeManagerHolder.setInstance((OfficeManager)manager);
            }
            return manager;
        }

        public Builder pipeNames(String ... pipeNames) {
            Validate.isTrue((pipeNames != null && pipeNames.length > 0 ? 1 : 0) != 0, (String)"The pipe name list must not be empty", (Object[])new Object[0]);
            this.pipeNames = (String[])ArrayUtils.clone((Object[])pipeNames);
            return this;
        }

        public Builder portNumbers(int ... portNumbers) {
            Validate.isTrue((portNumbers != null && portNumbers.length > 0 ? 1 : 0) != 0, (String)"The port number list must not be empty", (Object[])new Object[0]);
            this.portNumbers = ArrayUtils.clone((int[])portNumbers);
            return this;
        }

        public Builder officeHome(File officeHome) {
            this.officeHome = officeHome;
            return this;
        }

        public Builder officeHome(String officeHome) {
            return StringUtils.isBlank((CharSequence)officeHome) ? this : this.officeHome(new File(officeHome));
        }

        public Builder processManager(ProcessManager processManager) {
            Validate.notNull((Object)processManager, (String)"The process manager must not be null", (Object[])new Object[0]);
            this.processManager = processManager;
            return this;
        }

        public Builder processManager(String processManagerClass) {
            try {
                return StringUtils.isBlank((CharSequence)processManagerClass) ? this : this.processManager((ProcessManager)Class.forName(processManagerClass).newInstance());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                throw new IllegalArgumentException("Unable to create a Process manager from the specified class name: " + processManagerClass, ex);
            }
        }

        public Builder runAsArgs(String ... runAsArgs) {
            Validate.isTrue((runAsArgs != null && runAsArgs.length > 0 ? 1 : 0) != 0, (String)"The runAs argument list must not be empty", (Object[])new Object[0]);
            this.runAsArgs = (String[])ArrayUtils.clone((Object[])runAsArgs);
            return this;
        }

        public Builder templateProfileDir(File templateProfileDir) {
            this.templateProfileDir = templateProfileDir;
            return this;
        }

        public Builder templateProfileDir(String templateProfileDir) {
            return StringUtils.isBlank((CharSequence)templateProfileDir) ? this : this.templateProfileDir(new File(templateProfileDir));
        }

        public Builder templateProfileDirOrDefault(File templateProfileDir) {
            this.useDefaultOnInvalidTemplateProfileDir = true;
            this.templateProfileDir = templateProfileDir;
            return this;
        }

        public Builder templateProfileDirOrDefault(String templateProfileDir) {
            return StringUtils.isBlank((CharSequence)templateProfileDir) ? this : this.templateProfileDirOrDefault(new File(templateProfileDir));
        }

        public Builder killExistingProcess(boolean killExistingProcess) {
            this.killExistingProcess = killExistingProcess;
            return this;
        }

        public Builder processTimeout(long processTimeout) {
            Validate.inclusiveBetween((long)0L, (long)Long.MAX_VALUE, (long)processTimeout, (String)String.format("The processTimeout %s must be greater than or equal to 0", processTimeout));
            this.processTimeout = processTimeout;
            return this;
        }

        public Builder processRetryInterval(long processRetryInterval) {
            Validate.inclusiveBetween((long)0L, (long)10000L, (long)processRetryInterval, (String)String.format("The processRetryInterval %s must be in the inclusive range of %s to %s", processRetryInterval, 0, 10000L));
            this.processRetryInterval = processRetryInterval;
            return this;
        }

        public Builder maxTasksPerProcess(int maxTasksPerProcess) {
            Validate.inclusiveBetween((long)1L, (long)Integer.MAX_VALUE, (long)maxTasksPerProcess, (String)String.format("The maxTasksPerProcess %s greater than 0", maxTasksPerProcess));
            this.maxTasksPerProcess = maxTasksPerProcess;
            return this;
        }

        public Builder disableOpengl(boolean disableOpengl) {
            this.disableOpengl = disableOpengl;
            return this;
        }
    }
}

