/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.office;

import org.jodconverter.office.ConnectRetryable;
import org.jodconverter.office.OfficeConnection;
import org.jodconverter.office.OfficeContext;
import org.jodconverter.office.OfficeException;
import org.jodconverter.office.OfficeManager;
import org.jodconverter.office.OfficeUrl;
import org.jodconverter.task.OfficeTask;

class ExternalOfficeManager
implements OfficeManager {
    public static final long DEFAULT_RETRY_INTERVAL = 250L;
    private final OfficeConnection connection;
    private final boolean connectOnStart;
    private final long connectTimeout;

    public ExternalOfficeManager(OfficeUrl officeUrl, boolean connectOnStart, long connectTimeout) {
        this.connection = new OfficeConnection(officeUrl);
        this.connectOnStart = connectOnStart;
        this.connectTimeout = connectTimeout;
    }

    private void connect() throws OfficeException {
        try {
            new ConnectRetryable(this.connection).execute(250L, this.connectTimeout);
        }
        catch (Exception ex) {
            throw new OfficeException("Could not establish connection to external office process", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(OfficeTask task) throws OfficeException {
        OfficeConnection officeConnection = this.connection;
        synchronized (officeConnection) {
            if (!this.isRunning()) {
                this.connect();
            }
            task.execute((OfficeContext)this.connection);
        }
    }

    public boolean isRunning() {
        return this.connection.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws OfficeException {
        if (this.connectOnStart) {
            OfficeConnection officeConnection = this.connection;
            synchronized (officeConnection) {
                this.connect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        OfficeConnection officeConnection = this.connection;
        synchronized (officeConnection) {
            if (this.isRunning()) {
                this.connection.disconnect();
            }
        }
    }
}

