/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.filter.text;

import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XIndexAccess;
import com.sun.star.lang.XComponent;
import com.sun.star.text.XDocumentIndex;
import com.sun.star.text.XDocumentIndexesSupplier;
import com.sun.star.uno.UnoRuntime;
import org.jodconverter.filter.Filter;
import org.jodconverter.filter.FilterChain;
import org.jodconverter.office.OfficeContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableOfContentUpdaterFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableOfContentUpdaterFilter.class);
    private final int level;

    public TableOfContentUpdaterFilter() {
        this(0);
    }

    public TableOfContentUpdaterFilter(int level) {
        this.level = level;
    }

    @Override
    public void doFilter(OfficeContext context, XComponent document, FilterChain chain) throws Exception {
        LOGGER.debug("Applying the TableOfContentUpdaterFilter");
        XDocumentIndexesSupplier documentIndexesSupplier = (XDocumentIndexesSupplier)UnoRuntime.queryInterface(XDocumentIndexesSupplier.class, (Object)document);
        XIndexAccess documentIndexes = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)documentIndexesSupplier.getDocumentIndexes());
        for (int i = 0; i < documentIndexes.getCount(); ++i) {
            String indexType;
            XDocumentIndex docIndex = (XDocumentIndex)UnoRuntime.queryInterface(XDocumentIndex.class, (Object)documentIndexes.getByIndex(i));
            if (this.level > 0 && (indexType = docIndex.getServiceName()).contains("com.sun.star.text.ContentIndex")) {
                XPropertySet index = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)docIndex);
                index.setPropertyValue("Level", (Object)((short)this.level));
            }
            docIndex.update();
        }
        chain.doFilter(context, document);
    }
}

