/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.filter.text;

import com.sun.star.datatransfer.XTransferable;
import com.sun.star.datatransfer.XTransferableSupplier;
import com.sun.star.frame.XController;
import com.sun.star.lang.XComponent;
import com.sun.star.text.XPageCursor;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextViewCursor;
import com.sun.star.text.XTextViewCursorSupplier;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.view.XSelectionSupplier;
import org.jodconverter.filter.Filter;
import org.jodconverter.filter.FilterChain;
import org.jodconverter.office.OfficeContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageSelectorFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PageSelectorFilter.class);
    private final int page;

    public PageSelectorFilter(int page) {
        this.page = page;
    }

    @Override
    public void doFilter(OfficeContext context, XComponent document, FilterChain chain) throws Exception {
        LOGGER.debug("Applying the PageSelectorFilter");
        XTextDocument docText = (XTextDocument)UnoRuntime.queryInterface(XTextDocument.class, (Object)document);
        XController controller = docText.getCurrentController();
        XTextCursor textCursor = docText.getText().createTextCursor();
        XTextViewCursor viewCursor = ((XTextViewCursorSupplier)UnoRuntime.queryInterface(XTextViewCursorSupplier.class, (Object)controller)).getViewCursor();
        textCursor.gotoStart(false);
        viewCursor.gotoStart(false);
        XPageCursor pageCursor = (XPageCursor)UnoRuntime.queryInterface(XPageCursor.class, (Object)viewCursor);
        pageCursor.jumpToPage((short)this.page);
        textCursor.gotoRange(viewCursor.getStart(), false);
        pageCursor.jumpToEndOfPage();
        textCursor.gotoRange(viewCursor.getStart(), true);
        XSelectionSupplier selectionSupplier = (XSelectionSupplier)UnoRuntime.queryInterface(XSelectionSupplier.class, (Object)controller);
        selectionSupplier.select((Object)textCursor);
        XTransferableSupplier transferableSupplier = (XTransferableSupplier)UnoRuntime.queryInterface(XTransferableSupplier.class, (Object)controller);
        XTransferable xTransferable = transferableSupplier.getTransferable();
        textCursor.gotoStart(false);
        textCursor.gotoEnd(true);
        selectionSupplier.select((Object)textCursor);
        transferableSupplier.insertTransferable(xTransferable);
        chain.doFilter(context, document);
    }
}

