/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.process;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jodconverter.process.ProcessManager;
import org.jodconverter.process.ProcessQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProcessManager
implements ProcessManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractProcessManager.class);

    protected AbstractProcessManager() {
    }

    private String buildOutput(List<String> lines) {
        if (lines == null) {
            return "";
        }
        return lines.stream().filter(StringUtils::isNotBlank).collect(Collectors.joining("\n"));
    }

    protected List<String> execute(String[] cmdarray) throws IOException {
        Process process = Runtime.getRuntime().exec(cmdarray);
        StreamPumper outPumper = new StreamPumper(process.getInputStream());
        StreamPumper errPumper = new StreamPumper(process.getErrorStream());
        outPumper.start();
        errPumper.start();
        try {
            process.waitFor();
            outPumper.join();
            errPumper.join();
        }
        catch (InterruptedException ex) {
            LOGGER.warn("The current thread was interrupted while waiting for command execution output.", (Throwable)ex);
            Thread.currentThread().interrupt();
        }
        List<String> outLines = outPumper.getOutputLines();
        if (LOGGER.isDebugEnabled()) {
            String out = this.buildOutput(outLines);
            String err = this.buildOutput(errPumper.getOutputLines());
            if (!StringUtils.isBlank((CharSequence)out)) {
                LOGGER.trace("Command Output: {}", (Object)out);
            }
            if (!StringUtils.isBlank((CharSequence)err)) {
                LOGGER.trace("Command Error: {}", (Object)err);
            }
        }
        return outLines;
    }

    @Override
    public long findPid(ProcessQuery query) throws IOException {
        Pattern commandPattern = Pattern.compile(Pattern.quote(query.getCommand()) + ".*" + Pattern.quote(query.getArgument()));
        Pattern processLinePattern = this.getRunningProcessLinePattern();
        String[] currentProcessesCommand = this.getRunningProcessesCommand(query.getCommand());
        LOGGER.trace("Finding PID using\nCommand to get current running processes: {}\nRegex used to match current running process lines: {}\nRegex used to match running office process we are looking for: {}", new Object[]{currentProcessesCommand, processLinePattern.pattern(), commandPattern.pattern()});
        List<String> lines = this.execute(currentProcessesCommand);
        for (String line : lines) {
            if (StringUtils.isBlank((CharSequence)line)) continue;
            LOGGER.trace("Checking if process line matches the process line regex\nProcess line: {}", (Object)line);
            Matcher lineMatcher = processLinePattern.matcher(line);
            if (!lineMatcher.matches()) continue;
            String pid = lineMatcher.group("Pid");
            String commandLine = lineMatcher.group("CommanLine");
            LOGGER.trace("Line matches!\npid: {}; Command line: {}\nChecking if this command line matches the office command line regex", (Object)pid, (Object)commandLine);
            Matcher commandMatcher = commandPattern.matcher(commandLine);
            if (!commandMatcher.find()) continue;
            LOGGER.debug("Command line matches! Returning pid: {}", (Object)pid);
            return Long.parseLong(pid);
        }
        return -2L;
    }

    protected abstract String[] getRunningProcessesCommand(String var1);

    protected abstract Pattern getRunningProcessLinePattern();

    private static class StreamPumper
    extends Thread {
        private final InputStream inputStream;
        private final List<String> outputLines;

        public StreamPumper(InputStream inputStream) {
            this.inputStream = inputStream;
            this.outputLines = new ArrayList<String>();
        }

        public List<String> getOutputLines() {
            return this.outputLines;
        }

        @Override
        public void run() {
            try (InputStreamReader inputStreamReader = new InputStreamReader(this.inputStream);
                 BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                String line;
                while ((line = bufferedReader.readLine()) != null) {
                    this.outputLines.add(line);
                }
            }
            catch (IOException ex) {
                LOGGER.error("Unable to read from command input stream.", (Throwable)ex);
            }
        }
    }
}

