/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.ext;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.ext.ComponentNameProvider;
import org.jgrapht.ext.DIMACSFormat;
import org.jgrapht.ext.GraphExporter;
import org.jgrapht.ext.IntegerComponentNameProvider;

@Deprecated
public class DIMACSExporter<V, E>
implements GraphExporter<V, E> {
    public static final DIMACSFormat DEFAULT_DIMACS_FORMAT = DIMACSFormat.MAX_CLIQUE;
    private static final String HEADER = "Generated using the JGraphT library";
    private final ComponentNameProvider<V> vertexIDProvider;
    private final Set<Parameter> parameters;
    private DIMACSFormat format;

    public DIMACSExporter() {
        this(new IntegerComponentNameProvider());
    }

    public DIMACSExporter(ComponentNameProvider<V> vertexIDProvider) {
        this(vertexIDProvider, DEFAULT_DIMACS_FORMAT);
    }

    public DIMACSExporter(ComponentNameProvider<V> vertexIDProvider, DIMACSFormat format) {
        this.vertexIDProvider = Objects.requireNonNull(vertexIDProvider, "Vertex id provider cannot be null");
        this.format = Objects.requireNonNull(format, "Format cannot be null");
        this.parameters = new HashSet<Parameter>();
    }

    @Override
    public void exportGraph(Graph<V, E> g, Writer writer) {
        PrintWriter out = new PrintWriter(writer);
        out.println("c");
        out.println("c SOURCE: Generated using the JGraphT library");
        out.println("c");
        out.println("p " + this.format.getProblem() + " " + g.vertexSet().size() + " " + g.edgeSet().size());
        boolean exportEdgeWeights = this.parameters.contains((Object)Parameter.EXPORT_EDGE_WEIGHTS);
        for (Object edge : g.edgeSet()) {
            out.print(this.format.getEdgeDescriptor());
            out.print(" ");
            out.print(this.vertexIDProvider.getName(g.getEdgeSource(edge)));
            out.print(" ");
            out.print(this.vertexIDProvider.getName(g.getEdgeTarget(edge)));
            if (exportEdgeWeights) {
                out.print(" ");
                out.print(Double.toString(g.getEdgeWeight(edge)));
            }
            out.println();
        }
        out.flush();
    }

    public boolean isParameter(Parameter p) {
        return this.parameters.contains((Object)p);
    }

    public void setParameter(Parameter p, boolean value) {
        if (value) {
            this.parameters.add(p);
        } else {
            this.parameters.remove((Object)p);
        }
    }

    public DIMACSFormat getFormat() {
        return this.format;
    }

    public void setFormat(DIMACSFormat format) {
        this.format = Objects.requireNonNull(format, "Format cannot be null");
    }

    @Deprecated
    public static enum Parameter {
        EXPORT_EDGE_WEIGHTS;

    }
}

