/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart3d.table;

import java.awt.Color;
import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import org.jfree.chart3d.table.TableElement;
import org.jfree.chart3d.table.TableElementVisitor;
import org.jfree.chart3d.table.TextElement;

public class TableElementStyler
implements TableElementVisitor {
    private final Map<String, Font> fontChanges;
    private final Map<String, Color> foregroundColorChanges;
    private final Map<String, Color> backgroundColorChanges;

    public TableElementStyler(Map<String, Font> fontChanges, Map<String, Color> fgChanges, Map<String, Color> bgChanges) {
        this.fontChanges = new HashMap<String, Font>(fontChanges);
        this.foregroundColorChanges = fgChanges;
        this.backgroundColorChanges = bgChanges;
    }

    @Override
    public void visit(TableElement element) {
        if (element instanceof TextElement) {
            Color fg;
            Color bg;
            TextElement te = (TextElement)element;
            Font f = this.fontChanges.get(te.getTag());
            if (f != null) {
                te.setFont(f);
            }
            if ((bg = this.backgroundColorChanges.get(te.getTag())) != null) {
                te.setBackgroundColor(bg);
            }
            if ((fg = this.foregroundColorChanges.get(te.getTag())) != null) {
                te.setColor(fg);
            }
        }
    }
}

