/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart3d.table;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jfree.chart3d.internal.Args;
import org.jfree.chart3d.table.AbstractTableElement;
import org.jfree.chart3d.table.ElementDimension;
import org.jfree.chart3d.table.RectanglePainter;
import org.jfree.chart3d.table.TableElement;
import org.jfree.chart3d.table.TableElementOnDraw;
import org.jfree.chart3d.table.TableElementVisitor;

public class ShapeElement
extends AbstractTableElement
implements TableElement {
    private final Shape shape;
    private Color fillColor;

    public ShapeElement(Shape shape, Color fillColor) {
        Args.nullNotPermitted(shape, "shape");
        Args.nullNotPermitted(fillColor, "fillColor");
        this.shape = shape;
        this.fillColor = fillColor;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color color) {
        Args.nullNotPermitted(color, "color");
        this.fillColor = color;
    }

    @Override
    public Dimension2D preferredSize(Graphics2D g2, Rectangle2D bounds, Map<String, Object> constraints) {
        Insets insets = this.getInsets();
        Rectangle2D shapeBounds = this.shape.getBounds2D();
        return new ElementDimension(Math.min(shapeBounds.getWidth() + (double)insets.left + (double)insets.right, bounds.getWidth()), Math.min(shapeBounds.getHeight() + (double)insets.top + (double)insets.bottom, bounds.getHeight()));
    }

    @Override
    public List<Rectangle2D> layoutElements(Graphics2D g2, Rectangle2D bounds, Map<String, Object> constraints) {
        ArrayList<Rectangle2D> result = new ArrayList<Rectangle2D>(1);
        Insets insets = this.getInsets();
        Rectangle2D shapeBounds = this.shape.getBounds2D();
        double w = Math.min(shapeBounds.getWidth() + (double)insets.left + (double)insets.right, bounds.getWidth());
        double h = Math.min(shapeBounds.getHeight() + (double)insets.top + (double)insets.bottom, bounds.getHeight());
        Rectangle2D.Double pos = new Rectangle2D.Double(bounds.getCenterX() - w / 2.0, bounds.getCenterY() - h / 2.0, w, h);
        result.add(pos);
        return result;
    }

    @Override
    public void draw(Graphics2D g2, Rectangle2D bounds) {
        this.draw(g2, bounds, null);
    }

    @Override
    public void draw(Graphics2D g2, Rectangle2D bounds, TableElementOnDraw onDrawHandler) {
        if (onDrawHandler != null) {
            onDrawHandler.beforeDraw(this, g2, bounds);
        }
        AffineTransform saved = g2.getTransform();
        RectanglePainter background = this.getBackground();
        if (background != null) {
            background.fill(g2, bounds);
        }
        g2.translate(bounds.getCenterX(), bounds.getCenterY());
        g2.setPaint(this.fillColor);
        g2.fill(this.shape);
        g2.setTransform(saved);
        if (onDrawHandler != null) {
            onDrawHandler.afterDraw(this, g2, bounds);
        }
    }

    @Override
    public void receive(TableElementVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return "ShapeElement[shape=" + this.shape + "]";
    }
}

