/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart3d.style;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import javax.swing.event.EventListenerList;
import org.jfree.chart3d.Colors;
import org.jfree.chart3d.internal.Args;
import org.jfree.chart3d.internal.SerialUtils;
import org.jfree.chart3d.style.ChartStyle;
import org.jfree.chart3d.style.ChartStyleChangeEvent;
import org.jfree.chart3d.style.ChartStyleChangeListener;
import org.jfree.chart3d.table.RectanglePainter;
import org.jfree.chart3d.table.StandardRectanglePainter;

public class StandardChartStyle
implements ChartStyle,
Cloneable,
Serializable {
    private static final String FONT_FAMILY_1 = "Palatino Linotype";
    private static final String FONT_FAMILY_2 = "Palatino";
    public static final Color DEFAULT_TEXT_BACKGROUND_COLOR = new Color(255, 255, 255, 100);
    public static final Font DEFAULT_TITLE_FONT = StandardChartStyle.createDefaultFont(0, 32);
    public static final Font DEFAULT_SUBTITLE_FONT = StandardChartStyle.createDefaultFont(0, 18);
    public static final Color DEFAULT_CHARTBOX_COLOR = new Color(255, 255, 255, 100);
    public static final boolean DEFAULT_ROW_GRIDLINES_VISIBLE = false;
    public static final boolean DEFAULT_COLUMN_GRIDLINES_VISIBLE = false;
    public static final boolean DEFAULT_X_GRIDLINES_VISIBLE = true;
    public static final boolean DEFAULT_Y_GRIDLINES_VISIBLE = true;
    public static final boolean DEFAULT_Z_GRIDLINES_VISIBLE = true;
    public static final Color DEFAULT_GRIDLINE_COLOR = Color.GRAY;
    public static final Stroke DEFAULT_GRIDLINE_STROKE = new BasicStroke(0.0f);
    public static final Font DEFAULT_SECTION_LABEL_FONT = StandardChartStyle.createDefaultFont(0, 14);
    public static final Color DEFAULT_SECTION_LABEL_COLOR = Color.BLACK;
    public static final Font DEFAULT_AXIS_LABEL_FONT = StandardChartStyle.createDefaultFont(1, 12);
    public static final Color DEFAULT_AXIS_LABEL_COLOR = Color.BLACK;
    public static final Font DEFAULT_AXIS_TICK_LABEL_FONT = StandardChartStyle.createDefaultFont(0, 12);
    public static final Color DEFAULT_AXIS_TICK_LABEL_COLOR = Color.BLACK;
    public static final Font DEFAULT_LEGEND_HEADER_FONT = StandardChartStyle.createDefaultFont(1, 14);
    public static final Color DEFAULT_LEGEND_HEADER_COLOR = Color.BLACK;
    public static final Shape DEFAULT_LEGEND_ITEM_SHAPE = new Rectangle2D.Double(-6.0, -4.0, 12.0, 8.0);
    public static final Font DEFAULT_LEGEND_ITEM_FONT = StandardChartStyle.createDefaultFont(0, 12);
    public static final Color DEFAULT_LEGEND_ITEM_COLOR = Color.BLACK;
    public static final Color DEFAULT_LEGEND_ITEM_BACKGROUND_COLOR = new Color(255, 255, 255, 100);
    public static final Font DEFAULT_LEGEND_FOOTER_FONT = StandardChartStyle.createDefaultFont(0, 10);
    public static final Color DEFAULT_LEGEND_FOOTER_COLOR = Color.BLACK;
    public static final Font DEFAULT_MARKER_LABEL_FONT = StandardChartStyle.createDefaultFont(0, 10);
    public static final Color DEFAULT_MARKER_LABEL_COLOR = Color.DARK_GRAY;
    public static final Stroke DEFAULT_MARKER_LINE_STROKE = new BasicStroke(2.0f, 1, 1);
    public static final Color DEFAULT_MARKER_LINE_COLOR = Color.DARK_GRAY;
    public static final Color DEFAULT_MARKER_FILL_COLOR = new Color(127, 127, 127, 63);
    private RectanglePainter backgroundPainter;
    private Font titleFont;
    private Color titleColor;
    private Color titleBackgroundColor;
    private Font subtitleFont;
    private Color subtitleColor;
    private Color subtitleBackgroundColor;
    private Color chartBoxColor;
    private boolean rowAxisGridlinesVisible;
    private boolean columnAxisGridlinesVisible;
    private boolean xAxisGridlinesVisible;
    private boolean yAxisGridlinesVisible;
    private boolean zAxisGridlinesVisible;
    private Color gridlineColor;
    private transient Stroke gridlineStroke;
    private Font sectionLabelFont;
    private Color sectionLabelColor;
    private Color[] standardColors;
    private Font axisLabelFont;
    private Color axisLabelColor;
    private Font axisTickLabelFont;
    private Color axisTickLabelColor;
    private Font legendHeaderFont;
    private Color legendHeaderColor;
    private Color legendHeaderBackgroundColor;
    private Shape legendItemShape;
    private Font legendItemFont;
    private Color legendItemColor;
    private Color legendItemBackgroundColor;
    private Font legendFooterFont;
    private Color legendFooterColor;
    private Color legendFooterBackgroundColor;
    private Font markerLabelFont;
    private Color markerLabelColor;
    private transient Stroke markerLineStroke;
    private Color markerLineColor;
    private Color markerFillColor;
    private transient EventListenerList listenerList;
    private boolean notify;

    public static Font createDefaultFont(int style, int size) {
        Font f = new Font(FONT_FAMILY_1, style, size);
        if ("Dialog".equals(f.getFamily()) && "Dialog".equals((f = new Font(FONT_FAMILY_2, style, size)).getFamily())) {
            f = new Font("Serif", style, size);
        }
        return f;
    }

    public StandardChartStyle() {
        this.backgroundPainter = new StandardRectanglePainter(Color.WHITE);
        this.titleFont = DEFAULT_TITLE_FONT;
        this.titleColor = Color.BLACK;
        this.titleBackgroundColor = DEFAULT_TEXT_BACKGROUND_COLOR;
        this.subtitleColor = Color.BLACK;
        this.subtitleBackgroundColor = DEFAULT_TEXT_BACKGROUND_COLOR;
        this.subtitleFont = DEFAULT_SUBTITLE_FONT;
        this.chartBoxColor = DEFAULT_CHARTBOX_COLOR;
        this.rowAxisGridlinesVisible = false;
        this.columnAxisGridlinesVisible = false;
        this.xAxisGridlinesVisible = true;
        this.yAxisGridlinesVisible = true;
        this.zAxisGridlinesVisible = true;
        this.gridlineColor = DEFAULT_GRIDLINE_COLOR;
        this.gridlineStroke = DEFAULT_GRIDLINE_STROKE;
        this.sectionLabelFont = DEFAULT_SECTION_LABEL_FONT;
        this.sectionLabelColor = DEFAULT_SECTION_LABEL_COLOR;
        this.standardColors = Colors.getDefaultColors();
        this.axisLabelFont = DEFAULT_AXIS_LABEL_FONT;
        this.axisLabelColor = DEFAULT_AXIS_LABEL_COLOR;
        this.axisTickLabelFont = DEFAULT_AXIS_TICK_LABEL_FONT;
        this.axisTickLabelColor = DEFAULT_AXIS_TICK_LABEL_COLOR;
        this.legendHeaderFont = DEFAULT_LEGEND_HEADER_FONT;
        this.legendHeaderColor = DEFAULT_LEGEND_HEADER_COLOR;
        this.legendHeaderBackgroundColor = DEFAULT_TEXT_BACKGROUND_COLOR;
        this.legendItemShape = DEFAULT_LEGEND_ITEM_SHAPE;
        this.legendItemFont = DEFAULT_LEGEND_ITEM_FONT;
        this.legendItemColor = DEFAULT_LEGEND_ITEM_COLOR;
        this.legendItemBackgroundColor = DEFAULT_LEGEND_ITEM_BACKGROUND_COLOR;
        this.legendFooterFont = DEFAULT_LEGEND_FOOTER_FONT;
        this.legendFooterColor = DEFAULT_LEGEND_FOOTER_COLOR;
        this.legendFooterBackgroundColor = DEFAULT_TEXT_BACKGROUND_COLOR;
        this.markerLabelFont = DEFAULT_MARKER_LABEL_FONT;
        this.markerLabelColor = DEFAULT_MARKER_LABEL_COLOR;
        this.markerLineStroke = DEFAULT_MARKER_LINE_STROKE;
        this.markerLineColor = DEFAULT_MARKER_LINE_COLOR;
        this.markerFillColor = DEFAULT_MARKER_FILL_COLOR;
        this.listenerList = new EventListenerList();
        this.notify = true;
    }

    public StandardChartStyle(StandardChartStyle source) {
        Args.nullNotPermitted(source, "source");
        this.backgroundPainter = source.getBackgroundPainter();
        this.titleFont = source.getTitleFont();
        this.titleColor = source.getTitleColor();
        this.titleBackgroundColor = source.getTitleBackgroundColor();
        this.subtitleFont = source.getSubtitleFont();
        this.subtitleColor = source.getSubtitleColor();
        this.subtitleBackgroundColor = source.getSubtitleBackgroundColor();
        this.chartBoxColor = source.getChartBoxColor();
        this.xAxisGridlinesVisible = source.getXAxisGridlinesVisible();
        this.yAxisGridlinesVisible = source.getYAxisGridlinesVisible();
        this.zAxisGridlinesVisible = source.getZAxisGridlinesVisible();
        this.sectionLabelFont = source.getSectionLabelFont();
        this.sectionLabelColor = source.getSectionLabelColor();
        this.standardColors = source.getStandardColors();
        this.gridlineColor = source.getGridlineColor();
        this.gridlineStroke = source.getGridlineStroke();
        this.axisLabelFont = source.getAxisLabelFont();
        this.axisLabelColor = source.getAxisLabelColor();
        this.axisTickLabelFont = source.getAxisTickLabelFont();
        this.axisTickLabelColor = source.getAxisTickLabelColor();
        this.legendHeaderFont = source.getLegendHeaderFont();
        this.legendHeaderColor = source.getLegendHeaderColor();
        this.legendHeaderBackgroundColor = source.getLegendHeaderBackgroundColor();
        this.legendItemShape = source.getLegendItemShape();
        this.legendItemFont = source.getLegendItemFont();
        this.legendItemColor = source.getLegendItemColor();
        this.legendItemBackgroundColor = source.getLegendItemBackgroundColor();
        this.legendFooterFont = source.getLegendFooterFont();
        this.legendFooterColor = source.getLegendFooterColor();
        this.legendFooterBackgroundColor = source.getLegendFooterBackgroundColor();
        this.markerLabelFont = source.getMarkerLabelFont();
        this.markerLabelColor = source.getMarkerLabelColor();
        this.markerLineStroke = source.getMarkerLineStroke();
        this.markerLineColor = source.getMarkerLineColor();
        this.markerFillColor = source.getMarkerFillColor();
        this.listenerList = new EventListenerList();
        this.notify = true;
    }

    @Override
    public RectanglePainter getBackgroundPainter() {
        return this.backgroundPainter;
    }

    public void setBackgroundPainter(RectanglePainter painter) {
        Args.nullNotPermitted(painter, "painter");
        this.backgroundPainter = painter;
        this.fireChangeEvent();
    }

    @Override
    public Font getTitleFont() {
        return this.titleFont;
    }

    public void setTitleFont(Font font) {
        Args.nullNotPermitted(font, "font");
        this.titleFont = font;
        this.fireChangeEvent();
    }

    @Override
    public Color getTitleColor() {
        return this.titleColor;
    }

    public void setTitleColor(Color color) {
        this.titleColor = color;
        this.fireChangeEvent();
    }

    @Override
    public Color getTitleBackgroundColor() {
        return this.titleBackgroundColor;
    }

    public void setTitleBackgroundColor(Color color) {
        this.titleBackgroundColor = color;
        this.fireChangeEvent();
    }

    @Override
    public Font getSubtitleFont() {
        return this.subtitleFont;
    }

    public void setSubtitleFont(Font font) {
        Args.nullNotPermitted(font, "font");
        this.subtitleFont = font;
        this.fireChangeEvent();
    }

    @Override
    public Color getSubtitleColor() {
        return this.subtitleColor;
    }

    public void setSubtitleColor(Color color) {
        Args.nullNotPermitted(color, "color");
        this.subtitleColor = color;
        this.fireChangeEvent();
    }

    @Override
    public Color getSubtitleBackgroundColor() {
        return this.subtitleBackgroundColor;
    }

    public void setSubtitleBackgroundColor(Color color) {
        Args.nullNotPermitted(color, "color");
        this.subtitleBackgroundColor = color;
        this.fireChangeEvent();
    }

    @Override
    public Color getChartBoxColor() {
        return this.chartBoxColor;
    }

    public void setChartBoxColor(Color color) {
        Args.nullNotPermitted(color, "color");
        this.chartBoxColor = color;
        this.fireChangeEvent();
    }

    @Override
    public boolean getColumnAxisGridlinesVisible() {
        return this.columnAxisGridlinesVisible;
    }

    @Override
    public boolean getRowAxisGridlinesVisible() {
        return this.rowAxisGridlinesVisible;
    }

    @Override
    public boolean getXAxisGridlinesVisible() {
        return this.xAxisGridlinesVisible;
    }

    public void setXAxisGridlinesVisible(boolean visible) {
        this.xAxisGridlinesVisible = visible;
        this.fireChangeEvent();
    }

    @Override
    public boolean getYAxisGridlinesVisible() {
        return this.yAxisGridlinesVisible;
    }

    public void setYAxisGridlinesVisible(boolean visible) {
        this.yAxisGridlinesVisible = visible;
        this.fireChangeEvent();
    }

    @Override
    public boolean getZAxisGridlinesVisible() {
        return this.zAxisGridlinesVisible;
    }

    public void setZAxisGridlinesVisible(boolean visible) {
        this.zAxisGridlinesVisible = visible;
        this.fireChangeEvent();
    }

    @Override
    public Color getGridlineColor() {
        return this.gridlineColor;
    }

    public void setGridlineColor(Color color) {
        Args.nullNotPermitted(color, "color");
        this.gridlineColor = color;
        this.fireChangeEvent();
    }

    @Override
    public Stroke getGridlineStroke() {
        return this.gridlineStroke;
    }

    public void setGridlineStroke(Stroke stroke) {
        Args.nullNotPermitted(stroke, "stroke");
        this.gridlineStroke = stroke;
        this.fireChangeEvent();
    }

    @Override
    public Font getSectionLabelFont() {
        return this.sectionLabelFont;
    }

    public void setSectionLabelFont(Font font) {
        Args.nullNotPermitted(font, "font");
        this.sectionLabelFont = font;
        this.fireChangeEvent();
    }

    @Override
    public Color getSectionLabelColor() {
        return this.sectionLabelColor;
    }

    public void setSectionLabelColor(Color color) {
        Args.nullNotPermitted(color, "color");
        this.sectionLabelColor = color;
        this.fireChangeEvent();
    }

    @Override
    public Color[] getStandardColors() {
        return this.standardColors;
    }

    public void setStandardColors(Color ... colors) {
        this.standardColors = colors;
        this.fireChangeEvent();
    }

    @Override
    public Font getAxisLabelFont() {
        return this.axisLabelFont;
    }

    public void setAxisLabelFont(Font font) {
        Args.nullNotPermitted(font, "font");
        this.axisLabelFont = font;
        this.fireChangeEvent();
    }

    @Override
    public Color getAxisLabelColor() {
        return this.axisLabelColor;
    }

    public void setAxisLabelColor(Color color) {
        Args.nullNotPermitted(color, "color");
        this.axisLabelColor = color;
        this.fireChangeEvent();
    }

    @Override
    public Font getAxisTickLabelFont() {
        return this.axisTickLabelFont;
    }

    public void setAxisTickLabelFont(Font font) {
        Args.nullNotPermitted(font, "font");
        this.axisTickLabelFont = font;
        this.fireChangeEvent();
    }

    @Override
    public Color getAxisTickLabelColor() {
        return this.axisTickLabelColor;
    }

    public void setAxisTickLabelColor(Color color) {
        Args.nullNotPermitted(color, "color");
        this.axisTickLabelColor = color;
        this.fireChangeEvent();
    }

    @Override
    public Font getLegendHeaderFont() {
        return this.legendHeaderFont;
    }

    public void setLegendHeaderFont(Font font) {
        Args.nullNotPermitted(font, "font");
        this.legendHeaderFont = font;
        this.fireChangeEvent();
    }

    @Override
    public Color getLegendHeaderColor() {
        return this.legendHeaderColor;
    }

    public void setLegendHeaderColor(Color color) {
        Args.nullNotPermitted(color, "color");
        this.legendHeaderColor = color;
        this.fireChangeEvent();
    }

    @Override
    public Color getLegendHeaderBackgroundColor() {
        return this.legendHeaderBackgroundColor;
    }

    public void setLegendHeaderBackgroundColor(Color color) {
        Args.nullNotPermitted(color, "color");
        this.legendHeaderBackgroundColor = color;
        this.fireChangeEvent();
    }

    @Override
    public Shape getLegendItemShape() {
        return this.legendItemShape;
    }

    public void setLegendItemShape(Shape shape) {
        Args.nullNotPermitted(shape, "shape");
        this.legendItemShape = shape;
        this.fireChangeEvent();
    }

    @Override
    public Font getLegendItemFont() {
        return this.legendItemFont;
    }

    public void setLegendItemFont(Font font) {
        Args.nullNotPermitted(font, "font");
        this.legendItemFont = font;
        this.fireChangeEvent();
    }

    @Override
    public Color getLegendItemColor() {
        return this.legendItemColor;
    }

    public void setLegendItemColor(Color color) {
        Args.nullNotPermitted(color, "color");
        this.legendItemColor = color;
        this.fireChangeEvent();
    }

    @Override
    public Color getLegendItemBackgroundColor() {
        return this.legendItemBackgroundColor;
    }

    public void setLegendItemBackgroundColor(Color color) {
        Args.nullNotPermitted(color, "color");
        this.legendItemBackgroundColor = color;
        this.fireChangeEvent();
    }

    @Override
    public Font getLegendFooterFont() {
        return this.legendFooterFont;
    }

    public void setLegendFooterFont(Font font) {
        Args.nullNotPermitted(font, "font");
        this.legendFooterFont = font;
        this.fireChangeEvent();
    }

    @Override
    public Color getLegendFooterColor() {
        return this.legendFooterColor;
    }

    public void setLegendFooterColor(Color color) {
        Args.nullNotPermitted(color, "color");
        this.legendFooterColor = color;
        this.fireChangeEvent();
    }

    @Override
    public Color getLegendFooterBackgroundColor() {
        return this.legendFooterBackgroundColor;
    }

    public void setLegendFooterBackgroundColor(Color color) {
        Args.nullNotPermitted(color, "color");
        this.legendFooterBackgroundColor = color;
        this.fireChangeEvent();
    }

    @Override
    public Font getMarkerLabelFont() {
        return this.markerLabelFont;
    }

    public void setMarkerLabelFont(Font font) {
        Args.nullNotPermitted(font, "font");
        this.markerLabelFont = font;
        this.fireChangeEvent();
    }

    @Override
    public Color getMarkerLabelColor() {
        return this.markerLabelColor;
    }

    public void setMarkerLabelColor(Color color) {
        Args.nullNotPermitted(color, "color");
        this.markerLabelColor = color;
        this.fireChangeEvent();
    }

    @Override
    public Stroke getMarkerLineStroke() {
        return this.markerLineStroke;
    }

    public void setMarkerLineStroke(Stroke stroke) {
        Args.nullNotPermitted(stroke, "stroke");
        this.markerLineStroke = stroke;
        this.fireChangeEvent();
    }

    @Override
    public Color getMarkerLineColor() {
        return this.markerLineColor;
    }

    public void setMarkerLineColor(Color color) {
        Args.nullNotPermitted(color, "color");
        this.markerLineColor = color;
        this.fireChangeEvent();
    }

    @Override
    public Color getMarkerFillColor() {
        return this.markerFillColor;
    }

    public void setMarkerFillColor(Color color) {
        Args.nullNotPermitted(color, "color");
        this.markerFillColor = color;
        this.fireChangeEvent();
    }

    @Override
    public void addChangeListener(ChartStyleChangeListener listener) {
        this.listenerList.add(ChartStyleChangeListener.class, listener);
    }

    @Override
    public void removeChangeListener(ChartStyleChangeListener listener) {
        this.listenerList.remove(ChartStyleChangeListener.class, listener);
    }

    public void notifyListeners(ChartStyleChangeEvent event) {
        if (!this.notify) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChartStyleChangeListener.class) continue;
            ((ChartStyleChangeListener)listeners[i + 1]).styleChanged(event);
        }
    }

    public boolean isNotify() {
        return this.notify;
    }

    public void setNotify(boolean notify) {
        this.notify = notify;
        if (notify) {
            this.fireChangeEvent();
        }
    }

    protected void fireChangeEvent() {
        this.notifyListeners(new ChartStyleChangeEvent(this, this));
    }

    @Override
    public ChartStyle clone() {
        try {
            return (ChartStyle)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("If we get here, a bug needs fixing.");
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StandardChartStyle)) {
            return false;
        }
        StandardChartStyle that = (StandardChartStyle)obj;
        if (!this.backgroundPainter.equals(that.backgroundPainter)) {
            return false;
        }
        if (!this.titleFont.equals(that.titleFont)) {
            return false;
        }
        if (!this.titleColor.equals(that.titleColor)) {
            return false;
        }
        if (!this.titleBackgroundColor.equals(that.titleBackgroundColor)) {
            return false;
        }
        if (!this.subtitleFont.equals(that.subtitleFont)) {
            return false;
        }
        if (!this.subtitleColor.equals(that.subtitleColor)) {
            return false;
        }
        if (!this.subtitleBackgroundColor.equals(that.subtitleBackgroundColor)) {
            return false;
        }
        if (!this.chartBoxColor.equals(that.chartBoxColor)) {
            return false;
        }
        if (this.rowAxisGridlinesVisible != that.rowAxisGridlinesVisible) {
            return false;
        }
        if (this.columnAxisGridlinesVisible != that.columnAxisGridlinesVisible) {
            return false;
        }
        if (this.xAxisGridlinesVisible != that.xAxisGridlinesVisible) {
            return false;
        }
        if (this.yAxisGridlinesVisible != that.yAxisGridlinesVisible) {
            return false;
        }
        if (this.zAxisGridlinesVisible != that.zAxisGridlinesVisible) {
            return false;
        }
        if (!this.gridlineColor.equals(that.gridlineColor)) {
            return false;
        }
        if (!this.gridlineStroke.equals(that.gridlineStroke)) {
            return false;
        }
        if (!this.sectionLabelFont.equals(that.sectionLabelFont)) {
            return false;
        }
        if (!this.sectionLabelColor.equals(that.sectionLabelColor)) {
            return false;
        }
        if (!Arrays.equals(this.standardColors, that.standardColors)) {
            return false;
        }
        if (!this.axisLabelFont.equals(that.axisLabelFont)) {
            return false;
        }
        if (!this.axisLabelColor.equals(that.axisLabelColor)) {
            return false;
        }
        if (!this.axisTickLabelFont.equals(that.axisTickLabelFont)) {
            return false;
        }
        if (!this.axisTickLabelColor.equals(that.axisTickLabelColor)) {
            return false;
        }
        if (!this.legendHeaderFont.equals(that.legendHeaderFont)) {
            return false;
        }
        if (!this.legendHeaderColor.equals(that.legendHeaderColor)) {
            return false;
        }
        if (!this.legendHeaderBackgroundColor.equals(that.legendHeaderBackgroundColor)) {
            return false;
        }
        if (!this.legendItemShape.equals(that.legendItemShape)) {
            return false;
        }
        if (!this.legendItemFont.equals(that.legendItemFont)) {
            return false;
        }
        if (!this.legendItemColor.equals(that.legendItemColor)) {
            return false;
        }
        if (!this.legendItemBackgroundColor.equals(that.legendItemBackgroundColor)) {
            return false;
        }
        if (!this.legendFooterFont.equals(that.legendFooterFont)) {
            return false;
        }
        if (!this.legendFooterColor.equals(that.legendFooterColor)) {
            return false;
        }
        if (!this.legendFooterBackgroundColor.equals(that.legendFooterBackgroundColor)) {
            return false;
        }
        if (!this.markerLabelFont.equals(that.markerLabelFont)) {
            return false;
        }
        if (!this.markerLabelColor.equals(that.markerLabelColor)) {
            return false;
        }
        if (!this.markerLineColor.equals(that.markerLineColor)) {
            return false;
        }
        if (!this.markerLineStroke.equals(that.markerLineStroke)) {
            return false;
        }
        return this.markerFillColor.equals(that.markerFillColor);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        SerialUtils.writeStroke(this.gridlineStroke, stream);
        SerialUtils.writeStroke(this.markerLineStroke, stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.gridlineStroke = SerialUtils.readStroke(stream);
        this.markerLineStroke = SerialUtils.readStroke(stream);
    }
}

