/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart3d.style;

import java.awt.Color;
import java.awt.Font;
import org.jfree.chart3d.Colors;
import org.jfree.chart3d.style.ChartStyle;
import org.jfree.chart3d.style.StandardChartStyle;
import org.jfree.chart3d.table.StandardRectanglePainter;

public class ChartStyles {
    public static ChartStyle createOrson1Style() {
        StandardChartStyle s = new StandardChartStyle();
        s.setStandardColors(Colors.createFancyLightColors());
        return s;
    }

    public static ChartStyle createOrson2Style() {
        StandardChartStyle s = new StandardChartStyle();
        Color bgcolor = new Color(50, 50, 50, 150);
        s.setTitleColor(Color.LIGHT_GRAY);
        s.setTitleBackgroundColor(bgcolor);
        s.setSubtitleColor(Color.LIGHT_GRAY);
        s.setSubtitleBackgroundColor(bgcolor);
        s.setChartBoxColor(new Color(200, 200, 255, 50));
        s.setSectionLabelColor(Color.LIGHT_GRAY);
        s.setAxisLabelColor(Color.LIGHT_GRAY);
        s.setAxisTickLabelColor(Color.LIGHT_GRAY);
        s.setLegendHeaderColor(Color.LIGHT_GRAY);
        s.setLegendItemColor(Color.LIGHT_GRAY);
        s.setLegendHeaderBackgroundColor(bgcolor);
        s.setLegendItemBackgroundColor(bgcolor);
        s.setLegendFooterColor(Color.LIGHT_GRAY);
        s.setLegendFooterBackgroundColor(bgcolor);
        s.setStandardColors(Colors.createBlueOceanColors());
        s.setBackgroundPainter(new StandardRectanglePainter(Color.BLACK));
        s.setMarkerLabelColor(Color.LIGHT_GRAY);
        s.setMarkerLineColor(Color.LIGHT_GRAY);
        s.setMarkerFillColor(new Color(100, 100, 255, 32));
        return s;
    }

    public static ChartStyle createPastelStyle() {
        StandardChartStyle s = new StandardChartStyle();
        s.setStandardColors(Colors.createPastelColors());
        return s;
    }

    public static ChartStyle createIceCubeStyle() {
        StandardChartStyle s = new StandardChartStyle();
        s.setStandardColors(Colors.createIceCubeColors());
        s.setBackgroundPainter(new StandardRectanglePainter(Color.WHITE));
        return s;
    }

    public static ChartStyle createLogicalFontStyle() {
        StandardChartStyle s = new StandardChartStyle();
        s.setTitleFont(new Font("SansSerif", 1, 32));
        s.setSubtitleFont(new Font("Serif", 0, 16));
        s.setSectionLabelFont(new Font("Serif", 0, 16));
        s.setAxisLabelFont(new Font("Serif", 1, 16));
        s.setAxisTickLabelFont(new Font("Serif", 0, 14));
        s.setLegendHeaderFont(new Font("Serif", 1, 16));
        s.setLegendItemFont(new Font("Serif", 0, 14));
        s.setLegendFooterFont(new Font("Serif", 2, 10));
        s.setMarkerLabelFont(new Font("Serif", 0, 10));
        s.setStandardColors(Colors.createFancyLightColors());
        return s;
    }
}

