/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart3d.renderer.xyz;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart3d.axis.ValueAxis3D;
import org.jfree.chart3d.data.Range;
import org.jfree.chart3d.data.function.Function3D;
import org.jfree.chart3d.data.function.Function3DUtils;
import org.jfree.chart3d.data.xyz.XYZDataset;
import org.jfree.chart3d.graphics3d.Dimension3D;
import org.jfree.chart3d.graphics3d.Object3D;
import org.jfree.chart3d.graphics3d.Point3D;
import org.jfree.chart3d.graphics3d.World;
import org.jfree.chart3d.internal.Args;
import org.jfree.chart3d.plot.XYZPlot;
import org.jfree.chart3d.renderer.ColorScale;
import org.jfree.chart3d.renderer.ColorScaleRenderer;
import org.jfree.chart3d.renderer.ComposeType;
import org.jfree.chart3d.renderer.FixedColorScale;
import org.jfree.chart3d.renderer.xyz.AbstractXYZRenderer;
import org.jfree.chart3d.renderer.xyz.XYZRenderer;

public class SurfaceRenderer
extends AbstractXYZRenderer
implements XYZRenderer,
ColorScaleRenderer,
Serializable {
    private Function3D function;
    private int xSamples;
    private int zSamples;
    private ColorScale colorScale;
    private boolean drawFaceOutlines;

    public SurfaceRenderer(Function3D function) {
        Args.nullNotPermitted(function, "function");
        this.function = function;
        this.xSamples = 30;
        this.zSamples = 30;
        this.colorScale = new FixedColorScale(Color.YELLOW);
        this.drawFaceOutlines = true;
    }

    public int getXSamples() {
        return this.xSamples;
    }

    public void setXSamples(int count) {
        this.xSamples = count;
        this.fireChangeEvent(true);
    }

    public int getZSamples() {
        return this.zSamples;
    }

    public void setZSamples(int count) {
        this.zSamples = count;
    }

    @Override
    public ComposeType getComposeType() {
        return ComposeType.ALL;
    }

    @Override
    public ColorScale getColorScale() {
        return this.colorScale;
    }

    public void setColorScale(ColorScale colorScale) {
        Args.nullNotPermitted(colorScale, "colorScale");
        this.colorScale = colorScale;
        this.fireChangeEvent(true);
    }

    public boolean getDrawFaceOutlines() {
        return this.drawFaceOutlines;
    }

    public void setDrawFaceOutlines(boolean draw) {
        this.drawFaceOutlines = draw;
        this.fireChangeEvent(true);
    }

    @Override
    public void composeAll(XYZPlot plot, World world, Dimension3D dimensions, double xOffset, double yOffset, double zOffset) {
        ValueAxis3D xAxis = plot.getXAxis();
        ValueAxis3D yAxis = plot.getYAxis();
        ValueAxis3D zAxis = plot.getZAxis();
        Dimension3D dim = plot.getDimensions();
        double xlen = dim.getWidth();
        double ylen = dim.getHeight();
        double zlen = dim.getDepth();
        Range yRange = new Range(yOffset, -yOffset);
        for (int xIndex = 0; xIndex < this.xSamples; ++xIndex) {
            double xfrac0 = (double)xIndex / (double)this.xSamples;
            double xfrac1 = (double)(xIndex + 1) / (double)this.xSamples;
            for (int zIndex = 0; zIndex < this.zSamples; ++zIndex) {
                double zfrac0 = (double)zIndex / (double)this.zSamples;
                double zfrac1 = (double)(zIndex + 1) / (double)this.zSamples;
                double x0 = xAxis.getRange().value(xfrac0);
                double x1 = xAxis.getRange().value(xfrac1);
                double xm = x0 / 2.0 + x1 / 2.0;
                double z0 = zAxis.getRange().value(zfrac0);
                double z1 = zAxis.getRange().value(zfrac1);
                double zm = z0 / 2.0 + z1 / 2.0;
                double y00 = this.function.getValue(x0, z0);
                double y01 = this.function.getValue(x0, z1);
                double y10 = this.function.getValue(x1, z0);
                double y11 = this.function.getValue(x1, z1);
                double ymm = this.function.getValue(xm, zm);
                double wx0 = xAxis.translateToWorld(x0, xlen) + xOffset;
                double wx1 = xAxis.translateToWorld(x1, xlen) + xOffset;
                double wy00 = yAxis.translateToWorld(y00, ylen) + yOffset;
                double wy01 = yAxis.translateToWorld(y01, ylen) + yOffset;
                double wy10 = yAxis.translateToWorld(y10, ylen) + yOffset;
                double wy11 = yAxis.translateToWorld(y11, ylen) + yOffset;
                double wz0 = zAxis.translateToWorld(z0, zlen) + zOffset;
                double wz1 = zAxis.translateToWorld(z1, zlen) + zOffset;
                Color color = this.colorScale.valueToColor(ymm);
                Object3D obj = new Object3D(color, this.drawFaceOutlines);
                List<Point3D> pts1 = this.facePoints1(wx0, wx1, wz0, wz1, wy00, wy01, wy11, yRange);
                int count1 = pts1.size();
                for (Point3D pt : pts1) {
                    obj.addVertex(pt);
                }
                if (count1 == 3) {
                    obj.addDoubleSidedFace(new int[]{0, 1, 2});
                } else if (count1 == 4) {
                    obj.addDoubleSidedFace(new int[]{0, 1, 2, 3});
                } else if (count1 == 5) {
                    obj.addDoubleSidedFace(new int[]{0, 1, 2, 3, 4});
                }
                List<Point3D> pts2 = this.facePoints2(wx0, wx1, wz0, wz1, wy00, wy11, wy10, yRange);
                int count2 = pts2.size();
                for (Point3D pt : pts2) {
                    obj.addVertex(pt);
                }
                if (count2 == 3) {
                    obj.addDoubleSidedFace(new int[]{count1, count1 + 1, count1 + 2});
                } else if (count2 == 4) {
                    obj.addDoubleSidedFace(new int[]{count1, count1 + 1, count1 + 2, count1 + 3});
                } else if (count2 == 5) {
                    obj.addDoubleSidedFace(new int[]{count1, count1 + 1, count1 + 2, count1 + 3, count1 + 4});
                }
                world.add(obj);
            }
        }
    }

    private Point3D intersectPoint(double x0, double y0, double z0, double x1, double y1, double z1, double yy) {
        double p = (yy - y0) / (y1 - y0);
        double x = x0 + p * (x1 - x0);
        double y = y0 + p * (y1 - y0);
        double z = z0 + p * (z1 - z0);
        return new Point3D(x, y, z);
    }

    private List<Point3D> facePoints1(double x0, double x1, double z0, double z1, double y00, double y01, double y11, Range yRange) {
        ArrayList<Point3D> pts = new ArrayList<Point3D>(4);
        double ymin = yRange.getMin();
        double ymax = yRange.getMax();
        if (y00 > yRange.getMax()) {
            if (yRange.contains(y01)) {
                pts.add(this.intersectPoint(x0, y00, z0, x0, y01, z1, ymax));
            } else if (y01 < yRange.getMin()) {
                pts.add(this.intersectPoint(x0, y00, z0, x0, y01, z1, ymax));
                pts.add(this.intersectPoint(x0, y00, z0, x0, y01, z1, ymin));
            }
        } else if (yRange.contains(y00)) {
            pts.add(new Point3D(x0, y00, z0));
            if (y01 > yRange.getMax()) {
                pts.add(this.intersectPoint(x0, y00, z0, x0, y01, z1, ymax));
            } else if (y01 < yRange.getMin()) {
                pts.add(this.intersectPoint(x0, y00, z0, x0, y01, z1, ymin));
            }
        } else if (yRange.contains(y01)) {
            pts.add(this.intersectPoint(x0, y00, z0, x0, y01, z1, ymin));
        } else if (y01 > yRange.getMax()) {
            pts.add(this.intersectPoint(x0, y00, z0, x0, y01, z1, ymin));
            pts.add(this.intersectPoint(x0, y00, z0, x0, y01, z1, ymax));
        }
        if (y01 > yRange.getMax()) {
            if (yRange.contains(y11)) {
                pts.add(this.intersectPoint(x0, y01, z1, x1, y11, z1, ymax));
            } else if (y11 < yRange.getMin()) {
                pts.add(this.intersectPoint(x0, y01, z1, x1, y11, z1, ymax));
                pts.add(this.intersectPoint(x0, y01, z1, x1, y11, z1, ymin));
            }
        } else if (yRange.contains(y01)) {
            pts.add(new Point3D(x0, y01, z1));
            if (y11 > yRange.getMax()) {
                pts.add(this.intersectPoint(x0, y01, z1, x1, y11, z1, ymax));
            } else if (y11 < yRange.getMin()) {
                pts.add(this.intersectPoint(x0, y01, z1, x1, y11, z1, ymin));
            }
        } else if (y11 > yRange.getMax()) {
            pts.add(this.intersectPoint(x0, y01, z1, x1, y11, z1, ymin));
            pts.add(this.intersectPoint(x0, y01, z1, x1, y11, z1, ymax));
        } else if (yRange.contains(y11)) {
            pts.add(this.intersectPoint(x0, y01, z1, x1, y11, z1, ymin));
        }
        if (y11 > yRange.getMax()) {
            if (yRange.contains(y00)) {
                pts.add(this.intersectPoint(x1, y11, z1, x0, y00, z0, ymax));
            } else if (y00 < yRange.getMin()) {
                pts.add(this.intersectPoint(x1, y11, z1, x0, y00, z0, ymax));
                pts.add(this.intersectPoint(x1, y11, z1, x0, y00, z0, ymin));
            }
        } else if (yRange.contains(y11)) {
            pts.add(new Point3D(x1, y11, z1));
            if (y00 > yRange.getMax()) {
                pts.add(this.intersectPoint(x1, y11, z1, x0, y00, z0, ymax));
            } else if (y00 < yRange.getMin()) {
                pts.add(this.intersectPoint(x1, y11, z1, x0, y00, z0, ymin));
            }
        } else if (y00 > yRange.getMax()) {
            pts.add(this.intersectPoint(x1, y11, z1, x0, y00, z0, ymin));
            pts.add(this.intersectPoint(x1, y11, z1, x0, y00, z0, ymax));
        } else if (yRange.contains(y00)) {
            pts.add(this.intersectPoint(x1, y11, z1, x0, y00, z0, ymin));
        }
        return pts;
    }

    private List<Point3D> facePoints2(double x0, double x1, double z0, double z1, double y00, double y11, double y10, Range yRange) {
        ArrayList<Point3D> pts = new ArrayList<Point3D>(4);
        double ymin = yRange.getMin();
        double ymax = yRange.getMax();
        if (y00 > yRange.getMax()) {
            if (yRange.contains(y11)) {
                pts.add(this.intersectPoint(x0, y00, z0, x1, y11, z1, ymax));
            } else if (y11 < yRange.getMin()) {
                pts.add(this.intersectPoint(x0, y00, z0, x1, y11, z1, ymax));
                pts.add(this.intersectPoint(x0, y00, z0, x1, y11, z1, ymin));
            }
        } else if (yRange.contains(y00)) {
            pts.add(new Point3D(x0, y00, z0));
            if (y11 > yRange.getMax()) {
                pts.add(this.intersectPoint(x0, y00, z0, x1, y11, z1, ymax));
            } else if (y11 < yRange.getMin()) {
                pts.add(this.intersectPoint(x0, y00, z0, x1, y11, z1, ymin));
            }
        } else if (yRange.contains(y11)) {
            pts.add(this.intersectPoint(x0, y00, z0, x1, y11, z1, ymin));
        } else if (y11 > yRange.getMax()) {
            pts.add(this.intersectPoint(x0, y00, z0, x1, y11, z1, ymin));
            pts.add(this.intersectPoint(x0, y00, z0, x1, y11, z1, ymax));
        }
        if (y11 > yRange.getMax()) {
            if (yRange.contains(y10)) {
                pts.add(this.intersectPoint(x1, y11, z1, x1, y10, z0, ymax));
            } else if (y10 < yRange.getMin()) {
                pts.add(this.intersectPoint(x1, y11, z1, x1, y10, z0, ymax));
                pts.add(this.intersectPoint(x1, y11, z1, x1, y10, z0, ymin));
            }
        } else if (yRange.contains(y11)) {
            pts.add(new Point3D(x1, y11, z1));
            if (y10 > yRange.getMax()) {
                pts.add(this.intersectPoint(x1, y11, z1, x1, y10, z0, ymax));
            } else if (y10 < yRange.getMin()) {
                pts.add(this.intersectPoint(x1, y11, z1, x1, y10, z0, ymin));
            }
        } else if (y10 > yRange.getMax()) {
            pts.add(this.intersectPoint(x1, y11, z1, x1, y10, z0, ymin));
            pts.add(this.intersectPoint(x1, y11, z1, x1, y10, z0, ymax));
        } else if (yRange.contains(y10)) {
            pts.add(this.intersectPoint(x1, y11, z1, x1, y10, z0, ymin));
        }
        if (y10 > yRange.getMax()) {
            if (yRange.contains(y00)) {
                pts.add(this.intersectPoint(x1, y10, z0, x0, y00, z0, ymax));
            } else if (y00 < yRange.getMin()) {
                pts.add(this.intersectPoint(x1, y10, z0, x0, y00, z0, ymax));
                pts.add(this.intersectPoint(x1, y10, z0, x0, y00, z0, ymin));
            }
        } else if (yRange.contains(y10)) {
            pts.add(new Point3D(x1, y10, z0));
            if (y00 > yRange.getMax()) {
                pts.add(this.intersectPoint(x1, y10, z0, x0, y00, z0, ymax));
            } else if (y00 < yRange.getMin()) {
                pts.add(this.intersectPoint(x1, y10, z0, x0, y00, z0, ymin));
            }
        } else if (y00 > yRange.getMax()) {
            pts.add(this.intersectPoint(x1, y10, z0, x0, y00, z0, ymin));
            pts.add(this.intersectPoint(x1, y10, z0, x0, y00, z0, ymax));
        } else if (yRange.contains(y00)) {
            pts.add(this.intersectPoint(x1, y10, z0, x0, y00, z0, ymin));
        }
        return pts;
    }

    @Override
    public void composeItem(XYZDataset dataset, int series, int item, World world, Dimension3D dimensions, double xOffset, double yOffset, double zOffset) {
        throw new UnsupportedOperationException("Not supported by this renderer.");
    }

    @Override
    public Range findXRange(XYZDataset dataset) {
        return this.getPlot().getXAxis().getRange();
    }

    @Override
    public Range findYRange(XYZDataset dataset) {
        return Function3DUtils.findYRange(this.function, this.getPlot().getXAxis().getRange(), this.getPlot().getZAxis().getRange(), this.xSamples, this.zSamples, true);
    }

    @Override
    public Range findZRange(XYZDataset dataset) {
        return this.getPlot().getZAxis().getRange();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SurfaceRenderer)) {
            return false;
        }
        SurfaceRenderer that = (SurfaceRenderer)obj;
        if (!this.function.equals(that.function)) {
            return false;
        }
        if (this.xSamples != that.xSamples) {
            return false;
        }
        if (this.zSamples != that.zSamples) {
            return false;
        }
        if (!this.colorScale.equals(that.colorScale)) {
            return false;
        }
        if (this.drawFaceOutlines != that.drawFaceOutlines) {
            return false;
        }
        return super.equals(obj);
    }
}

