/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart3d.renderer.xyz;

import java.awt.Color;
import java.io.Serializable;
import org.jfree.chart3d.Colors;
import org.jfree.chart3d.internal.Args;
import org.jfree.chart3d.internal.ObjectUtils;
import org.jfree.chart3d.renderer.xyz.XYZColorSource;

public class StandardXYZColorSource
implements XYZColorSource,
Serializable {
    private Color[] colors;

    public StandardXYZColorSource() {
        this(Colors.getDefaultColors());
    }

    public StandardXYZColorSource(Color ... colors) {
        Args.nullNotPermitted(colors, "colors");
        if (colors.length == 0) {
            throw new IllegalArgumentException("Zero length array not permitted.");
        }
        for (Color c : colors) {
            if (c != null) continue;
            throw new IllegalArgumentException("Null array entries not permitted.");
        }
        this.colors = colors;
    }

    @Override
    public Color getColor(int series, int item) {
        return this.colors[series % this.colors.length];
    }

    @Override
    public Color getLegendColor(int series) {
        return this.colors[series % this.colors.length];
    }

    @Override
    public void style(Color ... colors) {
        Args.nullNotPermitted(colors, "colors");
        if (colors.length == 0) {
            throw new IllegalArgumentException("Zero length array not permitted.");
        }
        for (Color c : colors) {
            if (c != null) continue;
            throw new IllegalArgumentException("Null array entries not permitted.");
        }
        this.colors = (Color[])colors.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StandardXYZColorSource)) {
            return false;
        }
        StandardXYZColorSource that = (StandardXYZColorSource)obj;
        if (this.colors.length != that.colors.length) {
            return false;
        }
        for (int i = 0; i < this.colors.length; ++i) {
            if (ObjectUtils.equalsPaint(this.colors[i], that.colors[i])) continue;
            return false;
        }
        return true;
    }
}

