/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart3d.renderer.xyz;

import java.awt.Color;
import org.jfree.chart3d.data.DataUtils;
import org.jfree.chart3d.data.Range;
import org.jfree.chart3d.data.xyz.XYZDataset;
import org.jfree.chart3d.graphics3d.Dimension3D;
import org.jfree.chart3d.graphics3d.World;
import org.jfree.chart3d.internal.Args;
import org.jfree.chart3d.internal.ObjectUtils;
import org.jfree.chart3d.label.XYZItemLabelGenerator;
import org.jfree.chart3d.plot.XYZPlot;
import org.jfree.chart3d.renderer.AbstractRenderer3D;
import org.jfree.chart3d.renderer.ComposeType;
import org.jfree.chart3d.renderer.xyz.StandardXYZColorSource;
import org.jfree.chart3d.renderer.xyz.XYZColorSource;

public class AbstractXYZRenderer
extends AbstractRenderer3D {
    private XYZPlot plot;
    private XYZColorSource colorSource = new StandardXYZColorSource();
    private XYZItemLabelGenerator itemLabelGenerator = null;

    protected AbstractXYZRenderer() {
    }

    public XYZPlot getPlot() {
        return this.plot;
    }

    public void setPlot(XYZPlot plot) {
        this.plot = plot;
    }

    public XYZItemLabelGenerator getItemLabelGenerator() {
        return this.itemLabelGenerator;
    }

    public void setItemLabelGenerator(XYZItemLabelGenerator generator) {
        this.itemLabelGenerator = generator;
    }

    public ComposeType getComposeType() {
        return ComposeType.PER_ITEM;
    }

    public void composeAll(XYZPlot plot, World world, Dimension3D dimensions, double xOffset, double yOffset, double zOffset) {
        throw new UnsupportedOperationException();
    }

    public XYZColorSource getColorSource() {
        return this.colorSource;
    }

    public void setColorSource(XYZColorSource colorSource) {
        Args.nullNotPermitted(colorSource, "colorSource");
        this.colorSource = colorSource;
        this.fireChangeEvent(true);
    }

    public void setColors(Color ... colors) {
        this.setColorSource(new StandardXYZColorSource(colors));
    }

    public Range findXRange(XYZDataset dataset) {
        return DataUtils.findXRange(dataset);
    }

    public Range findYRange(XYZDataset dataset) {
        return DataUtils.findYRange(dataset);
    }

    public Range findZRange(XYZDataset dataset) {
        return DataUtils.findZRange(dataset);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractXYZRenderer)) {
            return false;
        }
        AbstractXYZRenderer that = (AbstractXYZRenderer)obj;
        if (!this.colorSource.equals(that.colorSource)) {
            return false;
        }
        if (!ObjectUtils.equals(this.itemLabelGenerator, that.itemLabelGenerator)) {
            return false;
        }
        return super.equals(obj);
    }
}

